/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetails;
import software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetailsListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainsForPackageResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, ListDomainsForPackageResponse> {
    private static final SdkField<List<DomainPackageDetails>> DOMAIN_PACKAGE_DETAILS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDomainsForPackageResponse.getter(ListDomainsForPackageResponse::domainPackageDetailsList)).setter(ListDomainsForPackageResponse.setter(Builder::domainPackageDetailsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainPackageDetailsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainPackageDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDomainsForPackageResponse.getter(ListDomainsForPackageResponse::nextToken)).setter(ListDomainsForPackageResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_PACKAGE_DETAILS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<DomainPackageDetails> domainPackageDetailsList;
    private final String nextToken;

    private ListDomainsForPackageResponse(BuilderImpl builder) {
        super(builder);
        this.domainPackageDetailsList = builder.domainPackageDetailsList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDomainPackageDetailsList() {
        return this.domainPackageDetailsList != null && !(this.domainPackageDetailsList instanceof SdkAutoConstructList);
    }

    public List<DomainPackageDetails> domainPackageDetailsList() {
        return this.domainPackageDetailsList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainPackageDetailsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsForPackageResponse)) {
            return false;
        }
        ListDomainsForPackageResponse other = (ListDomainsForPackageResponse)((Object)obj);
        return Objects.equals(this.domainPackageDetailsList(), other.domainPackageDetailsList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDomainsForPackageResponse").add("DomainPackageDetailsList", this.domainPackageDetailsList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainPackageDetailsList": {
                return Optional.ofNullable(clazz.cast(this.domainPackageDetailsList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainsForPackageResponse, T> g) {
        return obj -> g.apply((ListDomainsForPackageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private List<DomainPackageDetails> domainPackageDetailsList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsForPackageResponse model) {
            super(model);
            this.domainPackageDetailsList(model.domainPackageDetailsList);
            this.nextToken(model.nextToken);
        }

        public final Collection<DomainPackageDetails.Builder> getDomainPackageDetailsList() {
            return this.domainPackageDetailsList != null ? (Collection)this.domainPackageDetailsList.stream().map(DomainPackageDetails::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainPackageDetailsList(Collection<DomainPackageDetails> domainPackageDetailsList) {
            this.domainPackageDetailsList = DomainPackageDetailsListCopier.copy(domainPackageDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainPackageDetailsList(DomainPackageDetails ... domainPackageDetailsList) {
            this.domainPackageDetailsList(Arrays.asList(domainPackageDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainPackageDetailsList(Consumer<DomainPackageDetails.Builder> ... domainPackageDetailsList) {
            this.domainPackageDetailsList(Stream.of(domainPackageDetailsList).map(c -> (DomainPackageDetails)((DomainPackageDetails.Builder)DomainPackageDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainPackageDetailsList(Collection<DomainPackageDetails.BuilderImpl> domainPackageDetailsList) {
            this.domainPackageDetailsList = DomainPackageDetailsListCopier.copyFromBuilder(domainPackageDetailsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDomainsForPackageResponse build() {
            return new ListDomainsForPackageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainsForPackageResponse> {
        public Builder domainPackageDetailsList(Collection<DomainPackageDetails> var1);

        public Builder domainPackageDetailsList(DomainPackageDetails ... var1);

        public Builder domainPackageDetailsList(Consumer<DomainPackageDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

