/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of a reserved Elasticsearch instance offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedElasticsearchInstanceOffering implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedElasticsearchInstanceOffering.Builder, ReservedElasticsearchInstanceOffering> {
    private static final SdkField<String> RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedElasticsearchInstanceOffering::reservedElasticsearchInstanceOfferingId))
            .setter(setter(Builder::reservedElasticsearchInstanceOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReservedElasticsearchInstanceOfferingId").build()).build();

    private static final SdkField<String> ELASTICSEARCH_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedElasticsearchInstanceOffering::elasticsearchInstanceTypeAsString))
            .setter(setter(Builder::elasticsearchInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchInstanceType").build())
            .build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ReservedElasticsearchInstanceOffering::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(ReservedElasticsearchInstanceOffering::fixedPrice)).setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()).build();

    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(ReservedElasticsearchInstanceOffering::usagePrice)).setter(setter(Builder::usagePrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedElasticsearchInstanceOffering::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReservedElasticsearchInstanceOffering::paymentOptionAsString)).setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()).build();

    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField
            .<List<RecurringCharge>> builder(MarshallingType.LIST)
            .getter(getter(ReservedElasticsearchInstanceOffering::recurringCharges))
            .setter(setter(Builder::recurringCharges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecurringCharge> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecurringCharge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_ELASTICSEARCH_INSTANCE_OFFERING_ID_FIELD, ELASTICSEARCH_INSTANCE_TYPE_FIELD, DURATION_FIELD,
            FIXED_PRICE_FIELD, USAGE_PRICE_FIELD, CURRENCY_CODE_FIELD, PAYMENT_OPTION_FIELD, RECURRING_CHARGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reservedElasticsearchInstanceOfferingId;

    private final String elasticsearchInstanceType;

    private final Integer duration;

    private final Double fixedPrice;

    private final Double usagePrice;

    private final String currencyCode;

    private final String paymentOption;

    private final List<RecurringCharge> recurringCharges;

    private ReservedElasticsearchInstanceOffering(BuilderImpl builder) {
        this.reservedElasticsearchInstanceOfferingId = builder.reservedElasticsearchInstanceOfferingId;
        this.elasticsearchInstanceType = builder.elasticsearchInstanceType;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.paymentOption = builder.paymentOption;
        this.recurringCharges = builder.recurringCharges;
    }

    /**
     * <p>
     * The Elasticsearch reserved instance offering identifier.
     * </p>
     * 
     * @return The Elasticsearch reserved instance offering identifier.
     */
    public String reservedElasticsearchInstanceOfferingId() {
        return reservedElasticsearchInstanceOfferingId;
    }

    /**
     * <p>
     * The Elasticsearch instance type offered by the reserved instance offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #elasticsearchInstanceType} will return {@link ESPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #elasticsearchInstanceTypeAsString}.
     * </p>
     * 
     * @return The Elasticsearch instance type offered by the reserved instance offering.
     * @see ESPartitionInstanceType
     */
    public ESPartitionInstanceType elasticsearchInstanceType() {
        return ESPartitionInstanceType.fromValue(elasticsearchInstanceType);
    }

    /**
     * <p>
     * The Elasticsearch instance type offered by the reserved instance offering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #elasticsearchInstanceType} will return {@link ESPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #elasticsearchInstanceTypeAsString}.
     * </p>
     * 
     * @return The Elasticsearch instance type offered by the reserved instance offering.
     * @see ESPartitionInstanceType
     */
    public String elasticsearchInstanceTypeAsString() {
        return elasticsearchInstanceType;
    }

    /**
     * <p>
     * The duration, in seconds, for which the offering will reserve the Elasticsearch instance.
     * </p>
     * 
     * @return The duration, in seconds, for which the offering will reserve the Elasticsearch instance.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch instance offering.
     * </p>
     * 
     * @return The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch instance offering.
     */
    public Double fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The rate you are charged for each hour the domain that is using the offering is running.
     * </p>
     * 
     * @return The rate you are charged for each hour the domain that is using the offering is running.
     */
    public Double usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The currency code for the reserved Elasticsearch instance offering.
     * </p>
     * 
     * @return The currency code for the reserved Elasticsearch instance offering.
     */
    public String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * Payment option for the reserved Elasticsearch instance offering
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link ReservedElasticsearchInstancePaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return Payment option for the reserved Elasticsearch instance offering
     * @see ReservedElasticsearchInstancePaymentOption
     */
    public ReservedElasticsearchInstancePaymentOption paymentOption() {
        return ReservedElasticsearchInstancePaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * Payment option for the reserved Elasticsearch instance offering
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link ReservedElasticsearchInstancePaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return Payment option for the reserved Elasticsearch instance offering
     * @see ReservedElasticsearchInstancePaymentOption
     */
    public String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * Returns true if the RecurringCharges property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRecurringCharges() {
        return recurringCharges != null && !(recurringCharges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The charge to your account regardless of whether you are creating any domains using the instance offering.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecurringCharges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The charge to your account regardless of whether you are creating any domains using the instance
     *         offering.
     */
    public List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedElasticsearchInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recurringCharges());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedElasticsearchInstanceOffering)) {
            return false;
        }
        ReservedElasticsearchInstanceOffering other = (ReservedElasticsearchInstanceOffering) obj;
        return Objects.equals(reservedElasticsearchInstanceOfferingId(), other.reservedElasticsearchInstanceOfferingId())
                && Objects.equals(elasticsearchInstanceTypeAsString(), other.elasticsearchInstanceTypeAsString())
                && Objects.equals(duration(), other.duration()) && Objects.equals(fixedPrice(), other.fixedPrice())
                && Objects.equals(usagePrice(), other.usagePrice()) && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(recurringCharges(), other.recurringCharges());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReservedElasticsearchInstanceOffering")
                .add("ReservedElasticsearchInstanceOfferingId", reservedElasticsearchInstanceOfferingId())
                .add("ElasticsearchInstanceType", elasticsearchInstanceTypeAsString()).add("Duration", duration())
                .add("FixedPrice", fixedPrice()).add("UsagePrice", usagePrice()).add("CurrencyCode", currencyCode())
                .add("PaymentOption", paymentOptionAsString()).add("RecurringCharges", recurringCharges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedElasticsearchInstanceOfferingId":
            return Optional.ofNullable(clazz.cast(reservedElasticsearchInstanceOfferingId()));
        case "ElasticsearchInstanceType":
            return Optional.ofNullable(clazz.cast(elasticsearchInstanceTypeAsString()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "UsagePrice":
            return Optional.ofNullable(clazz.cast(usagePrice()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "RecurringCharges":
            return Optional.ofNullable(clazz.cast(recurringCharges()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedElasticsearchInstanceOffering, T> g) {
        return obj -> g.apply((ReservedElasticsearchInstanceOffering) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedElasticsearchInstanceOffering> {
        /**
         * <p>
         * The Elasticsearch reserved instance offering identifier.
         * </p>
         * 
         * @param reservedElasticsearchInstanceOfferingId
         *        The Elasticsearch reserved instance offering identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId);

        /**
         * <p>
         * The Elasticsearch instance type offered by the reserved instance offering.
         * </p>
         * 
         * @param elasticsearchInstanceType
         *        The Elasticsearch instance type offered by the reserved instance offering.
         * @see ESPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ESPartitionInstanceType
         */
        Builder elasticsearchInstanceType(String elasticsearchInstanceType);

        /**
         * <p>
         * The Elasticsearch instance type offered by the reserved instance offering.
         * </p>
         * 
         * @param elasticsearchInstanceType
         *        The Elasticsearch instance type offered by the reserved instance offering.
         * @see ESPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ESPartitionInstanceType
         */
        Builder elasticsearchInstanceType(ESPartitionInstanceType elasticsearchInstanceType);

        /**
         * <p>
         * The duration, in seconds, for which the offering will reserve the Elasticsearch instance.
         * </p>
         * 
         * @param duration
         *        The duration, in seconds, for which the offering will reserve the Elasticsearch instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch instance offering.
         * </p>
         * 
         * @param fixedPrice
         *        The upfront fixed charge you will pay to purchase the specific reserved Elasticsearch instance
         *        offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Double fixedPrice);

        /**
         * <p>
         * The rate you are charged for each hour the domain that is using the offering is running.
         * </p>
         * 
         * @param usagePrice
         *        The rate you are charged for each hour the domain that is using the offering is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Double usagePrice);

        /**
         * <p>
         * The currency code for the reserved Elasticsearch instance offering.
         * </p>
         * 
         * @param currencyCode
         *        The currency code for the reserved Elasticsearch instance offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * Payment option for the reserved Elasticsearch instance offering
         * </p>
         * 
         * @param paymentOption
         *        Payment option for the reserved Elasticsearch instance offering
         * @see ReservedElasticsearchInstancePaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedElasticsearchInstancePaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * Payment option for the reserved Elasticsearch instance offering
         * </p>
         * 
         * @param paymentOption
         *        Payment option for the reserved Elasticsearch instance offering
         * @see ReservedElasticsearchInstancePaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedElasticsearchInstancePaymentOption
         */
        Builder paymentOption(ReservedElasticsearchInstancePaymentOption paymentOption);

        /**
         * <p>
         * The charge to your account regardless of whether you are creating any domains using the instance offering.
         * </p>
         * 
         * @param recurringCharges
         *        The charge to your account regardless of whether you are creating any domains using the instance
         *        offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The charge to your account regardless of whether you are creating any domains using the instance offering.
         * </p>
         * 
         * @param recurringCharges
         *        The charge to your account regardless of whether you are creating any domains using the instance
         *        offering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The charge to your account regardless of whether you are creating any domains using the instance offering.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecurringCharge>.Builder} avoiding the need
         * to create one manually via {@link List<RecurringCharge>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecurringCharge>.Builder#build()} is called immediately and
         * its result is passed to {@link #recurringCharges(List<RecurringCharge>)}.
         * 
         * @param recurringCharges
         *        a consumer that will call methods on {@link List<RecurringCharge>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringCharges(List<RecurringCharge>)
         */
        Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges);
    }

    static final class BuilderImpl implements Builder {
        private String reservedElasticsearchInstanceOfferingId;

        private String elasticsearchInstanceType;

        private Integer duration;

        private Double fixedPrice;

        private Double usagePrice;

        private String currencyCode;

        private String paymentOption;

        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedElasticsearchInstanceOffering model) {
            reservedElasticsearchInstanceOfferingId(model.reservedElasticsearchInstanceOfferingId);
            elasticsearchInstanceType(model.elasticsearchInstanceType);
            duration(model.duration);
            fixedPrice(model.fixedPrice);
            usagePrice(model.usagePrice);
            currencyCode(model.currencyCode);
            paymentOption(model.paymentOption);
            recurringCharges(model.recurringCharges);
        }

        public final String getReservedElasticsearchInstanceOfferingId() {
            return reservedElasticsearchInstanceOfferingId;
        }

        @Override
        public final Builder reservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
            return this;
        }

        public final void setReservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
        }

        public final String getElasticsearchInstanceType() {
            return elasticsearchInstanceType;
        }

        @Override
        public final Builder elasticsearchInstanceType(String elasticsearchInstanceType) {
            this.elasticsearchInstanceType = elasticsearchInstanceType;
            return this;
        }

        @Override
        public final Builder elasticsearchInstanceType(ESPartitionInstanceType elasticsearchInstanceType) {
            this.elasticsearchInstanceType(elasticsearchInstanceType == null ? null : elasticsearchInstanceType.toString());
            return this;
        }

        public final void setElasticsearchInstanceType(String elasticsearchInstanceType) {
            this.elasticsearchInstanceType = elasticsearchInstanceType;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Double getFixedPrice() {
            return fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Double getUsagePrice() {
            return usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(ReservedElasticsearchInstancePaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return recurringCharges != null ? recurringCharges.stream().map(RecurringCharge::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges) {
            recurringCharges(Stream.of(recurringCharges).map(c -> RecurringCharge.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        @Override
        public ReservedElasticsearchInstanceOffering build() {
            return new ReservedElasticsearchInstanceOffering(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
