/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the connection status of an outbound cross-cluster search connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutboundCrossClusterSearchConnectionStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<OutboundCrossClusterSearchConnectionStatus.Builder, OutboundCrossClusterSearchConnectionStatus> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OutboundCrossClusterSearchConnectionStatus::statusCodeAsString)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OutboundCrossClusterSearchConnectionStatus::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD,
            MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String statusCode;

    private final String message;

    private OutboundCrossClusterSearchConnectionStatus(BuilderImpl builder) {
        this.statusCode = builder.statusCode;
        this.message = builder.message;
    }

    /**
     * <p>
     * The state code for outbound connection. This can be one of the following:
     * </p>
     * <ul>
     * <li>VALIDATING: The outbound connection request is being validated.</li>
     * <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
     * <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by destination domain
     * owner.</li>
     * <li>PROVISIONING: Outbound connection request is in process.</li>
     * <li>ACTIVE: Outbound connection is active and ready to use.</li>
     * <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
     * <li>DELETING: Outbound connection deletion is in progress.</li>
     * <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link OutboundCrossClusterSearchConnectionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The state code for outbound connection. This can be one of the following:</p>
     *         <ul>
     *         <li>VALIDATING: The outbound connection request is being validated.</li>
     *         <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
     *         <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by destination
     *         domain owner.</li>
     *         <li>PROVISIONING: Outbound connection request is in process.</li>
     *         <li>ACTIVE: Outbound connection is active and ready to use.</li>
     *         <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
     *         <li>DELETING: Outbound connection deletion is in progress.</li>
     *         <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
     * @see OutboundCrossClusterSearchConnectionStatusCode
     */
    public OutboundCrossClusterSearchConnectionStatusCode statusCode() {
        return OutboundCrossClusterSearchConnectionStatusCode.fromValue(statusCode);
    }

    /**
     * <p>
     * The state code for outbound connection. This can be one of the following:
     * </p>
     * <ul>
     * <li>VALIDATING: The outbound connection request is being validated.</li>
     * <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
     * <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by destination domain
     * owner.</li>
     * <li>PROVISIONING: Outbound connection request is in process.</li>
     * <li>ACTIVE: Outbound connection is active and ready to use.</li>
     * <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
     * <li>DELETING: Outbound connection deletion is in progress.</li>
     * <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link OutboundCrossClusterSearchConnectionStatusCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The state code for outbound connection. This can be one of the following:</p>
     *         <ul>
     *         <li>VALIDATING: The outbound connection request is being validated.</li>
     *         <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
     *         <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by destination
     *         domain owner.</li>
     *         <li>PROVISIONING: Outbound connection request is in process.</li>
     *         <li>ACTIVE: Outbound connection is active and ready to use.</li>
     *         <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
     *         <li>DELETING: Outbound connection deletion is in progress.</li>
     *         <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
     * @see OutboundCrossClusterSearchConnectionStatusCode
     */
    public String statusCodeAsString() {
        return statusCode;
    }

    /**
     * <p>
     * Specifies verbose information for the outbound connection status.
     * </p>
     * 
     * @return Specifies verbose information for the outbound connection status.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutboundCrossClusterSearchConnectionStatus)) {
            return false;
        }
        OutboundCrossClusterSearchConnectionStatus other = (OutboundCrossClusterSearchConnectionStatus) obj;
        return Objects.equals(statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OutboundCrossClusterSearchConnectionStatus").add("StatusCode", statusCodeAsString())
                .add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutboundCrossClusterSearchConnectionStatus, T> g) {
        return obj -> g.apply((OutboundCrossClusterSearchConnectionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutboundCrossClusterSearchConnectionStatus> {
        /**
         * <p>
         * The state code for outbound connection. This can be one of the following:
         * </p>
         * <ul>
         * <li>VALIDATING: The outbound connection request is being validated.</li>
         * <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
         * <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by destination
         * domain owner.</li>
         * <li>PROVISIONING: Outbound connection request is in process.</li>
         * <li>ACTIVE: Outbound connection is active and ready to use.</li>
         * <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
         * <li>DELETING: Outbound connection deletion is in progress.</li>
         * <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
         * </ul>
         * 
         * @param statusCode
         *        The state code for outbound connection. This can be one of the following:</p>
         *        <ul>
         *        <li>VALIDATING: The outbound connection request is being validated.</li>
         *        <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
         *        <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by
         *        destination domain owner.</li>
         *        <li>PROVISIONING: Outbound connection request is in process.</li>
         *        <li>ACTIVE: Outbound connection is active and ready to use.</li>
         *        <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
         *        <li>DELETING: Outbound connection deletion is in progress.</li>
         *        <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
         * @see OutboundCrossClusterSearchConnectionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutboundCrossClusterSearchConnectionStatusCode
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The state code for outbound connection. This can be one of the following:
         * </p>
         * <ul>
         * <li>VALIDATING: The outbound connection request is being validated.</li>
         * <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
         * <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by destination
         * domain owner.</li>
         * <li>PROVISIONING: Outbound connection request is in process.</li>
         * <li>ACTIVE: Outbound connection is active and ready to use.</li>
         * <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
         * <li>DELETING: Outbound connection deletion is in progress.</li>
         * <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
         * </ul>
         * 
         * @param statusCode
         *        The state code for outbound connection. This can be one of the following:</p>
         *        <ul>
         *        <li>VALIDATING: The outbound connection request is being validated.</li>
         *        <li>VALIDATION_FAILED: Validation failed for the connection request.</li>
         *        <li>PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet accepted by
         *        destination domain owner.</li>
         *        <li>PROVISIONING: Outbound connection request is in process.</li>
         *        <li>ACTIVE: Outbound connection is active and ready to use.</li>
         *        <li>REJECTED: Outbound connection request is rejected by destination domain owner.</li>
         *        <li>DELETING: Outbound connection deletion is in progress.</li>
         *        <li>DELETED: Outbound connection is deleted and cannot be used further.</li>
         * @see OutboundCrossClusterSearchConnectionStatusCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutboundCrossClusterSearchConnectionStatusCode
         */
        Builder statusCode(OutboundCrossClusterSearchConnectionStatusCode statusCode);

        /**
         * <p>
         * Specifies verbose information for the outbound connection status.
         * </p>
         * 
         * @param message
         *        Specifies verbose information for the outbound connection status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String statusCode;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(OutboundCrossClusterSearchConnectionStatus model) {
            statusCode(model.statusCode);
            message(model.message);
        }

        public final String getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(OutboundCrossClusterSearchConnectionStatusCode statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public OutboundCrossClusterSearchConnectionStatus build() {
            return new OutboundCrossClusterSearchConnectionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
