/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters returned by <code> <a>ListElasticsearchInstanceTypes</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListElasticsearchInstanceTypesResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<ListElasticsearchInstanceTypesResponse.Builder, ListElasticsearchInstanceTypesResponse> {
    private static final SdkField<List<String>> ELASTICSEARCH_INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListElasticsearchInstanceTypesResponse::elasticsearchInstanceTypesAsStrings))
            .setter(setter(Builder::elasticsearchInstanceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchInstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListElasticsearchInstanceTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ELASTICSEARCH_INSTANCE_TYPES_FIELD, NEXT_TOKEN_FIELD));

    private final List<String> elasticsearchInstanceTypes;

    private final String nextToken;

    private ListElasticsearchInstanceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.elasticsearchInstanceTypes = builder.elasticsearchInstanceTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * List of instance types supported by Amazon Elasticsearch service for given
     * <code> <a>ElasticsearchVersion</a> </code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElasticsearchInstanceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of instance types supported by Amazon Elasticsearch service for given
     *         <code> <a>ElasticsearchVersion</a> </code>
     */
    public List<ESPartitionInstanceType> elasticsearchInstanceTypes() {
        return ElasticsearchInstanceTypeListCopier.copyStringToEnum(elasticsearchInstanceTypes);
    }

    /**
     * Returns true if the ElasticsearchInstanceTypes property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasElasticsearchInstanceTypes() {
        return elasticsearchInstanceTypes != null && !(elasticsearchInstanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of instance types supported by Amazon Elasticsearch service for given
     * <code> <a>ElasticsearchVersion</a> </code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElasticsearchInstanceTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of instance types supported by Amazon Elasticsearch service for given
     *         <code> <a>ElasticsearchVersion</a> </code>
     */
    public List<String> elasticsearchInstanceTypesAsStrings() {
        return elasticsearchInstanceTypes;
    }

    /**
     * <p>
     * In case if there are more results available NextToken would be present, make further request to the same API with
     * received NextToken to paginate remaining results.
     * </p>
     * 
     * @return In case if there are more results available NextToken would be present, make further request to the same
     *         API with received NextToken to paginate remaining results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchInstanceTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListElasticsearchInstanceTypesResponse)) {
            return false;
        }
        ListElasticsearchInstanceTypesResponse other = (ListElasticsearchInstanceTypesResponse) obj;
        return Objects.equals(elasticsearchInstanceTypesAsStrings(), other.elasticsearchInstanceTypesAsStrings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListElasticsearchInstanceTypesResponse")
                .add("ElasticsearchInstanceTypes", elasticsearchInstanceTypesAsStrings()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticsearchInstanceTypes":
            return Optional.ofNullable(clazz.cast(elasticsearchInstanceTypesAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListElasticsearchInstanceTypesResponse, T> g) {
        return obj -> g.apply((ListElasticsearchInstanceTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListElasticsearchInstanceTypesResponse> {
        /**
         * <p>
         * List of instance types supported by Amazon Elasticsearch service for given
         * <code> <a>ElasticsearchVersion</a> </code>
         * </p>
         * 
         * @param elasticsearchInstanceTypes
         *        List of instance types supported by Amazon Elasticsearch service for given
         *        <code> <a>ElasticsearchVersion</a> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchInstanceTypesWithStrings(Collection<String> elasticsearchInstanceTypes);

        /**
         * <p>
         * List of instance types supported by Amazon Elasticsearch service for given
         * <code> <a>ElasticsearchVersion</a> </code>
         * </p>
         * 
         * @param elasticsearchInstanceTypes
         *        List of instance types supported by Amazon Elasticsearch service for given
         *        <code> <a>ElasticsearchVersion</a> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchInstanceTypesWithStrings(String... elasticsearchInstanceTypes);

        /**
         * <p>
         * List of instance types supported by Amazon Elasticsearch service for given
         * <code> <a>ElasticsearchVersion</a> </code>
         * </p>
         * 
         * @param elasticsearchInstanceTypes
         *        List of instance types supported by Amazon Elasticsearch service for given
         *        <code> <a>ElasticsearchVersion</a> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchInstanceTypes(Collection<ESPartitionInstanceType> elasticsearchInstanceTypes);

        /**
         * <p>
         * List of instance types supported by Amazon Elasticsearch service for given
         * <code> <a>ElasticsearchVersion</a> </code>
         * </p>
         * 
         * @param elasticsearchInstanceTypes
         *        List of instance types supported by Amazon Elasticsearch service for given
         *        <code> <a>ElasticsearchVersion</a> </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchInstanceTypes(ESPartitionInstanceType... elasticsearchInstanceTypes);

        /**
         * <p>
         * In case if there are more results available NextToken would be present, make further request to the same API
         * with received NextToken to paginate remaining results.
         * </p>
         * 
         * @param nextToken
         *        In case if there are more results available NextToken would be present, make further request to the
         *        same API with received NextToken to paginate remaining results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<String> elasticsearchInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListElasticsearchInstanceTypesResponse model) {
            super(model);
            elasticsearchInstanceTypesWithStrings(model.elasticsearchInstanceTypes);
            nextToken(model.nextToken);
        }

        public final Collection<String> getElasticsearchInstanceTypes() {
            return elasticsearchInstanceTypes;
        }

        @Override
        public final Builder elasticsearchInstanceTypesWithStrings(Collection<String> elasticsearchInstanceTypes) {
            this.elasticsearchInstanceTypes = ElasticsearchInstanceTypeListCopier.copy(elasticsearchInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticsearchInstanceTypesWithStrings(String... elasticsearchInstanceTypes) {
            elasticsearchInstanceTypesWithStrings(Arrays.asList(elasticsearchInstanceTypes));
            return this;
        }

        @Override
        public final Builder elasticsearchInstanceTypes(Collection<ESPartitionInstanceType> elasticsearchInstanceTypes) {
            this.elasticsearchInstanceTypes = ElasticsearchInstanceTypeListCopier.copyEnumToString(elasticsearchInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticsearchInstanceTypes(ESPartitionInstanceType... elasticsearchInstanceTypes) {
            elasticsearchInstanceTypes(Arrays.asList(elasticsearchInstanceTypes));
            return this;
        }

        public final void setElasticsearchInstanceTypes(Collection<String> elasticsearchInstanceTypes) {
            this.elasticsearchInstanceTypes = ElasticsearchInstanceTypeListCopier.copy(elasticsearchInstanceTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListElasticsearchInstanceTypesResponse build() {
            return new ListElasticsearchInstanceTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
