/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for response parameters to <code> <a>ListDomainsForPackage</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainsForPackageResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<ListDomainsForPackageResponse.Builder, ListDomainsForPackageResponse> {
    private static final SdkField<List<DomainPackageDetails>> DOMAIN_PACKAGE_DETAILS_LIST_FIELD = SdkField
            .<List<DomainPackageDetails>> builder(MarshallingType.LIST)
            .getter(getter(ListDomainsForPackageResponse::domainPackageDetailsList))
            .setter(setter(Builder::domainPackageDetailsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainPackageDetailsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainPackageDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainPackageDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListDomainsForPackageResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOMAIN_PACKAGE_DETAILS_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<DomainPackageDetails> domainPackageDetailsList;

    private final String nextToken;

    private ListDomainsForPackageResponse(BuilderImpl builder) {
        super(builder);
        this.domainPackageDetailsList = builder.domainPackageDetailsList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DomainPackageDetailsList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDomainPackageDetailsList() {
        return domainPackageDetailsList != null && !(domainPackageDetailsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of <code>DomainPackageDetails</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDomainPackageDetailsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of <code>DomainPackageDetails</code> objects.
     */
    public List<DomainPackageDetails> domainPackageDetailsList() {
        return domainPackageDetailsList;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainPackageDetailsList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsForPackageResponse)) {
            return false;
        }
        ListDomainsForPackageResponse other = (ListDomainsForPackageResponse) obj;
        return Objects.equals(domainPackageDetailsList(), other.domainPackageDetailsList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDomainsForPackageResponse").add("DomainPackageDetailsList", domainPackageDetailsList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainPackageDetailsList":
            return Optional.ofNullable(clazz.cast(domainPackageDetailsList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainsForPackageResponse, T> g) {
        return obj -> g.apply((ListDomainsForPackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDomainsForPackageResponse> {
        /**
         * <p>
         * List of <code>DomainPackageDetails</code> objects.
         * </p>
         * 
         * @param domainPackageDetailsList
         *        List of <code>DomainPackageDetails</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainPackageDetailsList(Collection<DomainPackageDetails> domainPackageDetailsList);

        /**
         * <p>
         * List of <code>DomainPackageDetails</code> objects.
         * </p>
         * 
         * @param domainPackageDetailsList
         *        List of <code>DomainPackageDetails</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainPackageDetailsList(DomainPackageDetails... domainPackageDetailsList);

        /**
         * <p>
         * List of <code>DomainPackageDetails</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DomainPackageDetails>.Builder} avoiding the
         * need to create one manually via {@link List<DomainPackageDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DomainPackageDetails>.Builder#build()} is called immediately
         * and its result is passed to {@link #domainPackageDetailsList(List<DomainPackageDetails>)}.
         * 
         * @param domainPackageDetailsList
         *        a consumer that will call methods on {@link List<DomainPackageDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainPackageDetailsList(List<DomainPackageDetails>)
         */
        Builder domainPackageDetailsList(Consumer<DomainPackageDetails.Builder>... domainPackageDetailsList);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<DomainPackageDetails> domainPackageDetailsList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsForPackageResponse model) {
            super(model);
            domainPackageDetailsList(model.domainPackageDetailsList);
            nextToken(model.nextToken);
        }

        public final Collection<DomainPackageDetails.Builder> getDomainPackageDetailsList() {
            return domainPackageDetailsList != null ? domainPackageDetailsList.stream().map(DomainPackageDetails::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainPackageDetailsList(Collection<DomainPackageDetails> domainPackageDetailsList) {
            this.domainPackageDetailsList = DomainPackageDetailsListCopier.copy(domainPackageDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainPackageDetailsList(DomainPackageDetails... domainPackageDetailsList) {
            domainPackageDetailsList(Arrays.asList(domainPackageDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainPackageDetailsList(Consumer<DomainPackageDetails.Builder>... domainPackageDetailsList) {
            domainPackageDetailsList(Stream.of(domainPackageDetailsList)
                    .map(c -> DomainPackageDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainPackageDetailsList(Collection<DomainPackageDetails.BuilderImpl> domainPackageDetailsList) {
            this.domainPackageDetailsList = DomainPackageDetailsListCopier.copyFromBuilder(domainPackageDetailsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDomainsForPackageResponse build() {
            return new ListDomainsForPackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
