/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for request parameters to <code> <a>DeletePackage</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePackageRequest extends ElasticsearchRequest implements
        ToCopyableBuilder<DeletePackageRequest.Builder, DeletePackageRequest> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeletePackageRequest::packageID)).setter(setter(Builder::packageID))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PackageID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD));

    private final String packageID;

    private DeletePackageRequest(BuilderImpl builder) {
        super(builder);
        this.packageID = builder.packageID;
    }

    /**
     * <p>
     * Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.
     * </p>
     * 
     * @return Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.
     */
    public String packageID() {
        return packageID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageID());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePackageRequest)) {
            return false;
        }
        DeletePackageRequest other = (DeletePackageRequest) obj;
        return Objects.equals(packageID(), other.packageID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeletePackageRequest").add("PackageID", packageID()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageID":
            return Optional.ofNullable(clazz.cast(packageID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePackageRequest, T> g) {
        return obj -> g.apply((DeletePackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeletePackageRequest> {
        /**
         * <p>
         * Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this value.
         * </p>
         * 
         * @param packageID
         *        Internal ID of the package that you want to delete. Use <code>DescribePackages</code> to find this
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageID(String packageID);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticsearchRequest.BuilderImpl implements Builder {
        private String packageID;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePackageRequest model) {
            super(model);
            packageID(model.packageID);
        }

        public final String getPackageID() {
            return packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePackageRequest build() {
            return new DeletePackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
