/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for response returned by <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCompatibleElasticsearchVersionsResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<GetCompatibleElasticsearchVersionsResponse.Builder, GetCompatibleElasticsearchVersionsResponse> {
    private static final SdkField<List<CompatibleVersionsMap>> COMPATIBLE_ELASTICSEARCH_VERSIONS_FIELD = SdkField
            .<List<CompatibleVersionsMap>> builder(MarshallingType.LIST)
            .getter(getter(GetCompatibleElasticsearchVersionsResponse::compatibleElasticsearchVersions))
            .setter(setter(Builder::compatibleElasticsearchVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleElasticsearchVersions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompatibleVersionsMap> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompatibleVersionsMap::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COMPATIBLE_ELASTICSEARCH_VERSIONS_FIELD));

    private final List<CompatibleVersionsMap> compatibleElasticsearchVersions;

    private GetCompatibleElasticsearchVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.compatibleElasticsearchVersions = builder.compatibleElasticsearchVersions;
    }

    /**
     * Returns true if the CompatibleElasticsearchVersions property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasCompatibleElasticsearchVersions() {
        return compatibleElasticsearchVersions != null && !(compatibleElasticsearchVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map of compatible Elasticsearch versions returned as part of the
     * <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCompatibleElasticsearchVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of compatible Elasticsearch versions returned as part of the
     *         <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
     */
    public List<CompatibleVersionsMap> compatibleElasticsearchVersions() {
        return compatibleElasticsearchVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(compatibleElasticsearchVersions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCompatibleElasticsearchVersionsResponse)) {
            return false;
        }
        GetCompatibleElasticsearchVersionsResponse other = (GetCompatibleElasticsearchVersionsResponse) obj;
        return Objects.equals(compatibleElasticsearchVersions(), other.compatibleElasticsearchVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetCompatibleElasticsearchVersionsResponse")
                .add("CompatibleElasticsearchVersions", compatibleElasticsearchVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompatibleElasticsearchVersions":
            return Optional.ofNullable(clazz.cast(compatibleElasticsearchVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCompatibleElasticsearchVersionsResponse, T> g) {
        return obj -> g.apply((GetCompatibleElasticsearchVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCompatibleElasticsearchVersionsResponse> {
        /**
         * <p>
         * A map of compatible Elasticsearch versions returned as part of the
         * <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
         * </p>
         * 
         * @param compatibleElasticsearchVersions
         *        A map of compatible Elasticsearch versions returned as part of the
         *        <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleElasticsearchVersions(Collection<CompatibleVersionsMap> compatibleElasticsearchVersions);

        /**
         * <p>
         * A map of compatible Elasticsearch versions returned as part of the
         * <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
         * </p>
         * 
         * @param compatibleElasticsearchVersions
         *        A map of compatible Elasticsearch versions returned as part of the
         *        <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleElasticsearchVersions(CompatibleVersionsMap... compatibleElasticsearchVersions);

        /**
         * <p>
         * A map of compatible Elasticsearch versions returned as part of the
         * <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CompatibleVersionsMap>.Builder} avoiding
         * the need to create one manually via {@link List<CompatibleVersionsMap>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CompatibleVersionsMap>.Builder#build()} is called
         * immediately and its result is passed to {@link #compatibleElasticsearchVersions(List<CompatibleVersionsMap>)}
         * .
         * 
         * @param compatibleElasticsearchVersions
         *        a consumer that will call methods on {@link List<CompatibleVersionsMap>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compatibleElasticsearchVersions(List<CompatibleVersionsMap>)
         */
        Builder compatibleElasticsearchVersions(Consumer<CompatibleVersionsMap.Builder>... compatibleElasticsearchVersions);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<CompatibleVersionsMap> compatibleElasticsearchVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCompatibleElasticsearchVersionsResponse model) {
            super(model);
            compatibleElasticsearchVersions(model.compatibleElasticsearchVersions);
        }

        public final Collection<CompatibleVersionsMap.Builder> getCompatibleElasticsearchVersions() {
            return compatibleElasticsearchVersions != null ? compatibleElasticsearchVersions.stream()
                    .map(CompatibleVersionsMap::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder compatibleElasticsearchVersions(Collection<CompatibleVersionsMap> compatibleElasticsearchVersions) {
            this.compatibleElasticsearchVersions = CompatibleElasticsearchVersionsListCopier
                    .copy(compatibleElasticsearchVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleElasticsearchVersions(CompatibleVersionsMap... compatibleElasticsearchVersions) {
            compatibleElasticsearchVersions(Arrays.asList(compatibleElasticsearchVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleElasticsearchVersions(
                Consumer<CompatibleVersionsMap.Builder>... compatibleElasticsearchVersions) {
            compatibleElasticsearchVersions(Stream.of(compatibleElasticsearchVersions)
                    .map(c -> CompatibleVersionsMap.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCompatibleElasticsearchVersions(
                Collection<CompatibleVersionsMap.BuilderImpl> compatibleElasticsearchVersions) {
            this.compatibleElasticsearchVersions = CompatibleElasticsearchVersionsListCopier
                    .copyFromBuilder(compatibleElasticsearchVersions);
        }

        @Override
        public GetCompatibleElasticsearchVersionsResponse build() {
            return new GetCompatibleElasticsearchVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
