/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum ESPartitionInstanceType {
    M3_MEDIUM_ELASTICSEARCH("m3.medium.elasticsearch"),

    M3_LARGE_ELASTICSEARCH("m3.large.elasticsearch"),

    M3_XLARGE_ELASTICSEARCH("m3.xlarge.elasticsearch"),

    M3_2_XLARGE_ELASTICSEARCH("m3.2xlarge.elasticsearch"),

    M4_LARGE_ELASTICSEARCH("m4.large.elasticsearch"),

    M4_XLARGE_ELASTICSEARCH("m4.xlarge.elasticsearch"),

    M4_2_XLARGE_ELASTICSEARCH("m4.2xlarge.elasticsearch"),

    M4_4_XLARGE_ELASTICSEARCH("m4.4xlarge.elasticsearch"),

    M4_10_XLARGE_ELASTICSEARCH("m4.10xlarge.elasticsearch"),

    M5_LARGE_ELASTICSEARCH("m5.large.elasticsearch"),

    M5_XLARGE_ELASTICSEARCH("m5.xlarge.elasticsearch"),

    M5_2_XLARGE_ELASTICSEARCH("m5.2xlarge.elasticsearch"),

    M5_4_XLARGE_ELASTICSEARCH("m5.4xlarge.elasticsearch"),

    M5_12_XLARGE_ELASTICSEARCH("m5.12xlarge.elasticsearch"),

    R5_LARGE_ELASTICSEARCH("r5.large.elasticsearch"),

    R5_XLARGE_ELASTICSEARCH("r5.xlarge.elasticsearch"),

    R5_2_XLARGE_ELASTICSEARCH("r5.2xlarge.elasticsearch"),

    R5_4_XLARGE_ELASTICSEARCH("r5.4xlarge.elasticsearch"),

    R5_12_XLARGE_ELASTICSEARCH("r5.12xlarge.elasticsearch"),

    C5_LARGE_ELASTICSEARCH("c5.large.elasticsearch"),

    C5_XLARGE_ELASTICSEARCH("c5.xlarge.elasticsearch"),

    C5_2_XLARGE_ELASTICSEARCH("c5.2xlarge.elasticsearch"),

    C5_4_XLARGE_ELASTICSEARCH("c5.4xlarge.elasticsearch"),

    C5_9_XLARGE_ELASTICSEARCH("c5.9xlarge.elasticsearch"),

    C5_18_XLARGE_ELASTICSEARCH("c5.18xlarge.elasticsearch"),

    ULTRAWARM1_MEDIUM_ELASTICSEARCH("ultrawarm1.medium.elasticsearch"),

    ULTRAWARM1_LARGE_ELASTICSEARCH("ultrawarm1.large.elasticsearch"),

    T2_MICRO_ELASTICSEARCH("t2.micro.elasticsearch"),

    T2_SMALL_ELASTICSEARCH("t2.small.elasticsearch"),

    T2_MEDIUM_ELASTICSEARCH("t2.medium.elasticsearch"),

    R3_LARGE_ELASTICSEARCH("r3.large.elasticsearch"),

    R3_XLARGE_ELASTICSEARCH("r3.xlarge.elasticsearch"),

    R3_2_XLARGE_ELASTICSEARCH("r3.2xlarge.elasticsearch"),

    R3_4_XLARGE_ELASTICSEARCH("r3.4xlarge.elasticsearch"),

    R3_8_XLARGE_ELASTICSEARCH("r3.8xlarge.elasticsearch"),

    I2_XLARGE_ELASTICSEARCH("i2.xlarge.elasticsearch"),

    I2_2_XLARGE_ELASTICSEARCH("i2.2xlarge.elasticsearch"),

    D2_XLARGE_ELASTICSEARCH("d2.xlarge.elasticsearch"),

    D2_2_XLARGE_ELASTICSEARCH("d2.2xlarge.elasticsearch"),

    D2_4_XLARGE_ELASTICSEARCH("d2.4xlarge.elasticsearch"),

    D2_8_XLARGE_ELASTICSEARCH("d2.8xlarge.elasticsearch"),

    C4_LARGE_ELASTICSEARCH("c4.large.elasticsearch"),

    C4_XLARGE_ELASTICSEARCH("c4.xlarge.elasticsearch"),

    C4_2_XLARGE_ELASTICSEARCH("c4.2xlarge.elasticsearch"),

    C4_4_XLARGE_ELASTICSEARCH("c4.4xlarge.elasticsearch"),

    C4_8_XLARGE_ELASTICSEARCH("c4.8xlarge.elasticsearch"),

    R4_LARGE_ELASTICSEARCH("r4.large.elasticsearch"),

    R4_XLARGE_ELASTICSEARCH("r4.xlarge.elasticsearch"),

    R4_2_XLARGE_ELASTICSEARCH("r4.2xlarge.elasticsearch"),

    R4_4_XLARGE_ELASTICSEARCH("r4.4xlarge.elasticsearch"),

    R4_8_XLARGE_ELASTICSEARCH("r4.8xlarge.elasticsearch"),

    R4_16_XLARGE_ELASTICSEARCH("r4.16xlarge.elasticsearch"),

    I3_LARGE_ELASTICSEARCH("i3.large.elasticsearch"),

    I3_XLARGE_ELASTICSEARCH("i3.xlarge.elasticsearch"),

    I3_2_XLARGE_ELASTICSEARCH("i3.2xlarge.elasticsearch"),

    I3_4_XLARGE_ELASTICSEARCH("i3.4xlarge.elasticsearch"),

    I3_8_XLARGE_ELASTICSEARCH("i3.8xlarge.elasticsearch"),

    I3_16_XLARGE_ELASTICSEARCH("i3.16xlarge.elasticsearch"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ESPartitionInstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ESPartitionInstanceType corresponding to the value
     */
    public static ESPartitionInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ESPartitionInstanceType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ESPartitionInstanceType}s
     */
    public static Set<ESPartitionInstanceType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
