/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DescribeElasticsearchDomains</code> request. Contains the status of the specified domains or
 * all domains owned by the account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeElasticsearchDomainsResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<DescribeElasticsearchDomainsResponse.Builder, DescribeElasticsearchDomainsResponse> {
    private static final SdkField<List<ElasticsearchDomainStatus>> DOMAIN_STATUS_LIST_FIELD = SdkField
            .<List<ElasticsearchDomainStatus>> builder(MarshallingType.LIST)
            .getter(getter(DescribeElasticsearchDomainsResponse::domainStatusList))
            .setter(setter(Builder::domainStatusList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainStatusList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ElasticsearchDomainStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticsearchDomainStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_STATUS_LIST_FIELD));

    private final List<ElasticsearchDomainStatus> domainStatusList;

    private DescribeElasticsearchDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domainStatusList = builder.domainStatusList;
    }

    /**
     * Returns true if the DomainStatusList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDomainStatusList() {
        return domainStatusList != null && !(domainStatusList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDomainStatusList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
     */
    public List<ElasticsearchDomainStatus> domainStatusList() {
        return domainStatusList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainStatusList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchDomainsResponse)) {
            return false;
        }
        DescribeElasticsearchDomainsResponse other = (DescribeElasticsearchDomainsResponse) obj;
        return Objects.equals(domainStatusList(), other.domainStatusList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeElasticsearchDomainsResponse").add("DomainStatusList", domainStatusList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainStatusList":
            return Optional.ofNullable(clazz.cast(domainStatusList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticsearchDomainsResponse, T> g) {
        return obj -> g.apply((DescribeElasticsearchDomainsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeElasticsearchDomainsResponse> {
        /**
         * <p>
         * The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
         * </p>
         * 
         * @param domainStatusList
         *        The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainStatusList(Collection<ElasticsearchDomainStatus> domainStatusList);

        /**
         * <p>
         * The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
         * </p>
         * 
         * @param domainStatusList
         *        The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainStatusList(ElasticsearchDomainStatus... domainStatusList);

        /**
         * <p>
         * The status of the domains requested in the <code>DescribeElasticsearchDomains</code> request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ElasticsearchDomainStatus>.Builder}
         * avoiding the need to create one manually via {@link List<ElasticsearchDomainStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticsearchDomainStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #domainStatusList(List<ElasticsearchDomainStatus>)}.
         * 
         * @param domainStatusList
         *        a consumer that will call methods on {@link List<ElasticsearchDomainStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainStatusList(List<ElasticsearchDomainStatus>)
         */
        Builder domainStatusList(Consumer<ElasticsearchDomainStatus.Builder>... domainStatusList);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private List<ElasticsearchDomainStatus> domainStatusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchDomainsResponse model) {
            super(model);
            domainStatusList(model.domainStatusList);
        }

        public final Collection<ElasticsearchDomainStatus.Builder> getDomainStatusList() {
            return domainStatusList != null ? domainStatusList.stream().map(ElasticsearchDomainStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainStatusList(Collection<ElasticsearchDomainStatus> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copy(domainStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(ElasticsearchDomainStatus... domainStatusList) {
            domainStatusList(Arrays.asList(domainStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(Consumer<ElasticsearchDomainStatus.Builder>... domainStatusList) {
            domainStatusList(Stream.of(domainStatusList).map(c -> ElasticsearchDomainStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDomainStatusList(Collection<ElasticsearchDomainStatus.BuilderImpl> domainStatusList) {
            this.domainStatusList = ElasticsearchDomainStatusListCopier.copyFromBuilder(domainStatusList);
        }

        @Override
        public DescribeElasticsearchDomainsResponse build() {
            return new DescribeElasticsearchDomainsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
