/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptionsStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SnapshotOptionsStatusMarshaller {
    private static final MarshallingInfo<StructuredPojo> OPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Options").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final SnapshotOptionsStatusMarshaller INSTANCE = new SnapshotOptionsStatusMarshaller();

    private SnapshotOptionsStatusMarshaller() {
    }

    public static SnapshotOptionsStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SnapshotOptionsStatus snapshotOptionsStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)snapshotOptionsStatus, (String)"snapshotOptionsStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)snapshotOptionsStatus.options(), OPTIONS_BINDING);
            protocolMarshaller.marshall((Object)snapshotOptionsStatus.status(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

