/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ElasticsearchDomainConfigMarshaller {
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchVersion").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHCLUSTERCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchClusterConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EBSOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EBSOptions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACCESSPOLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessPolicies").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SNAPSHOTOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotOptions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VPCOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VPCOptions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ADVANCEDOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdvancedOptions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> LOGPUBLISHINGOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogPublishingOptions").isBinary(false).build();
    private static final ElasticsearchDomainConfigMarshaller INSTANCE = new ElasticsearchDomainConfigMarshaller();

    private ElasticsearchDomainConfigMarshaller() {
    }

    public static ElasticsearchDomainConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchDomainConfig elasticsearchDomainConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)elasticsearchDomainConfig, (String)"elasticsearchDomainConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.elasticsearchVersion(), ELASTICSEARCHVERSION_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.elasticsearchClusterConfig(), ELASTICSEARCHCLUSTERCONFIG_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.ebsOptions(), EBSOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.accessPolicies(), ACCESSPOLICIES_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.snapshotOptions(), SNAPSHOTOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.vpcOptions(), VPCOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.advancedOptions(), ADVANCEDOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainConfig.logPublishingOptions(), LOGPUBLISHINGOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

