/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptions;

@SdkInternalApi
public class EBSOptionsMarshaller {
    private static final MarshallingInfo<Boolean> EBSENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EBSEnabled").build();
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").build();
    private static final MarshallingInfo<Integer> VOLUMESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeSize").build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").build();
    private static final EBSOptionsMarshaller INSTANCE = new EBSOptionsMarshaller();

    public static EBSOptionsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EBSOptions ebsOptions, ProtocolMarshaller protocolMarshaller) {
        if (ebsOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ebsOptions.ebsEnabled(), EBSENABLED_BINDING);
            protocolMarshaller.marshall((Object)ebsOptions.volumeTypeString(), VOLUMETYPE_BINDING);
            protocolMarshaller.marshall((Object)ebsOptions.volumeSize(), VOLUMESIZE_BINDING);
            protocolMarshaller.marshall((Object)ebsOptions.iops(), IOPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

