/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.StringListCopier;
import software.amazon.awssdk.services.elasticsearch.transform.VPCDerivedInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VPCDerivedInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, VPCDerivedInfo> {
    private final String vpcId;
    private final List<String> subnetIds;
    private final List<String> availabilityZones;
    private final List<String> securityGroupIds;

    private VPCDerivedInfo(BuilderImpl builder) {
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.availabilityZones = builder.availabilityZones;
        this.securityGroupIds = builder.securityGroupIds;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPCDerivedInfo)) {
            return false;
        }
        VPCDerivedInfo other = (VPCDerivedInfo)obj;
        return Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.securityGroupIds(), other.securityGroupIds());
    }

    public String toString() {
        return ToString.builder((String)"VPCDerivedInfo").add("VPCId", (Object)this.vpcId()).add("SubnetIds", this.subnetIds()).add("AvailabilityZones", this.availabilityZones()).add("SecurityGroupIds", this.securityGroupIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VPCId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
            case "AvailabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
            case "SecurityGroupIds": {
                return Optional.of(clazz.cast(this.securityGroupIds()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VPCDerivedInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcId;
        private List<String> subnetIds;
        private List<String> availabilityZones;
        private List<String> securityGroupIds;

        private BuilderImpl() {
        }

        private BuilderImpl(VPCDerivedInfo model) {
            this.vpcId(model.vpcId);
            this.subnetIds(model.subnetIds);
            this.availabilityZones(model.availabilityZones);
            this.securityGroupIds(model.securityGroupIds);
        }

        public final String getVPCId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVPCId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        public VPCDerivedInfo build() {
            return new VPCDerivedInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VPCDerivedInfo> {
        public Builder vpcId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);
    }
}

