/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.transform.InstanceCountLimitsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceCountLimits
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceCountLimits> {
    private final Integer minimumInstanceCount;
    private final Integer maximumInstanceCount;

    private InstanceCountLimits(BuilderImpl builder) {
        this.minimumInstanceCount = builder.minimumInstanceCount;
        this.maximumInstanceCount = builder.maximumInstanceCount;
    }

    public Integer minimumInstanceCount() {
        return this.minimumInstanceCount;
    }

    public Integer maximumInstanceCount() {
        return this.maximumInstanceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumInstanceCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCountLimits)) {
            return false;
        }
        InstanceCountLimits other = (InstanceCountLimits)obj;
        return Objects.equals(this.minimumInstanceCount(), other.minimumInstanceCount()) && Objects.equals(this.maximumInstanceCount(), other.maximumInstanceCount());
    }

    public String toString() {
        return ToString.builder((String)"InstanceCountLimits").add("MinimumInstanceCount", (Object)this.minimumInstanceCount()).add("MaximumInstanceCount", (Object)this.maximumInstanceCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumInstanceCount": {
                return Optional.of(clazz.cast(this.minimumInstanceCount()));
            }
            case "MaximumInstanceCount": {
                return Optional.of(clazz.cast(this.maximumInstanceCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceCountLimitsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minimumInstanceCount;
        private Integer maximumInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCountLimits model) {
            this.minimumInstanceCount(model.minimumInstanceCount);
            this.maximumInstanceCount(model.maximumInstanceCount);
        }

        public final Integer getMinimumInstanceCount() {
            return this.minimumInstanceCount;
        }

        @Override
        public final Builder minimumInstanceCount(Integer minimumInstanceCount) {
            this.minimumInstanceCount = minimumInstanceCount;
            return this;
        }

        public final void setMinimumInstanceCount(Integer minimumInstanceCount) {
            this.minimumInstanceCount = minimumInstanceCount;
        }

        public final Integer getMaximumInstanceCount() {
            return this.maximumInstanceCount;
        }

        @Override
        public final Builder maximumInstanceCount(Integer maximumInstanceCount) {
            this.maximumInstanceCount = maximumInstanceCount;
            return this;
        }

        public final void setMaximumInstanceCount(Integer maximumInstanceCount) {
            this.maximumInstanceCount = maximumInstanceCount;
        }

        public InstanceCountLimits build() {
            return new InstanceCountLimits(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceCountLimits> {
        public Builder minimumInstanceCount(Integer var1);

        public Builder maximumInstanceCount(Integer var1);
    }
}

