/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.transform.LogPublishingOptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LogPublishingOption
implements StructuredPojo,
ToCopyableBuilder<Builder, LogPublishingOption> {
    private final String cloudWatchLogsLogGroupArn;
    private final Boolean enabled;

    private LogPublishingOption(BuilderImpl builder) {
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
        this.enabled = builder.enabled;
    }

    public String cloudWatchLogsLogGroupArn() {
        return this.cloudWatchLogsLogGroupArn;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogPublishingOption)) {
            return false;
        }
        LogPublishingOption other = (LogPublishingOption)obj;
        return Objects.equals(this.cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn()) && Objects.equals(this.enabled(), other.enabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cloudWatchLogsLogGroupArn() != null) {
            sb.append("CloudWatchLogsLogGroupArn: ").append(this.cloudWatchLogsLogGroupArn()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchLogsLogGroupArn": {
                return Optional.of(clazz.cast(this.cloudWatchLogsLogGroupArn()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LogPublishingOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudWatchLogsLogGroupArn;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(LogPublishingOption model) {
            this.cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
            this.enabled(model.enabled);
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return this.cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public LogPublishingOption build() {
            return new LogPublishingOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LogPublishingOption> {
        public Builder cloudWatchLogsLogGroupArn(String var1);

        public Builder enabled(Boolean var1);
    }
}

