/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.elasticsearch.model.DomainNameListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticsearchDomainsRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, DescribeElasticsearchDomainsRequest> {
    private final List<String> domainNames;

    private DescribeElasticsearchDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.domainNames = builder.domainNames;
    }

    public List<String> domainNames() {
        return this.domainNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchDomainsRequest)) {
            return false;
        }
        DescribeElasticsearchDomainsRequest other = (DescribeElasticsearchDomainsRequest)((Object)obj);
        return Objects.equals(this.domainNames(), other.domainNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainNames() != null) {
            sb.append("DomainNames: ").append(this.domainNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainNames": {
                return Optional.of(clazz.cast(this.domainNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private List<String> domainNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchDomainsRequest model) {
            this.domainNames(model.domainNames);
        }

        public final Collection<String> getDomainNames() {
            return this.domainNames;
        }

        @Override
        public final Builder domainNames(Collection<String> domainNames) {
            this.domainNames = DomainNameListCopier.copy(domainNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNames(String ... domainNames) {
            this.domainNames(Arrays.asList(domainNames));
            return this;
        }

        public final void setDomainNames(Collection<String> domainNames) {
            this.domainNames = DomainNameListCopier.copy(domainNames);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeElasticsearchDomainsRequest build() {
            return new DescribeElasticsearchDomainsRequest(this);
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    CopyableBuilder<Builder, DescribeElasticsearchDomainsRequest> {
        public Builder domainNames(Collection<String> var1);

        public Builder domainNames(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

