/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListElasticsearchInstanceTypesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListElasticsearchInstanceTypesRequest> {
    private final String elasticsearchVersion;
    private final String domainName;
    private final Integer maxResults;
    private final String nextToken;

    private ListElasticsearchInstanceTypesRequest(BuilderImpl builder) {
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.domainName = builder.domainName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public String elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public String domainName() {
        return this.domainName;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListElasticsearchInstanceTypesRequest)) {
            return false;
        }
        ListElasticsearchInstanceTypesRequest other = (ListElasticsearchInstanceTypesRequest)((Object)obj);
        return Objects.equals(this.elasticsearchVersion(), other.elasticsearchVersion()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.elasticsearchVersion() != null) {
            sb.append("ElasticsearchVersion: ").append(this.elasticsearchVersion()).append(",");
        }
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticsearchVersion": {
                return Optional.of(clazz.cast(this.elasticsearchVersion()));
            }
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "MaxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String elasticsearchVersion;
        private String domainName;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListElasticsearchInstanceTypesRequest model) {
            this.elasticsearchVersion(model.elasticsearchVersion);
            this.domainName(model.domainName);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getElasticsearchVersion() {
            return this.elasticsearchVersion;
        }

        @Override
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListElasticsearchInstanceTypesRequest build() {
            return new ListElasticsearchInstanceTypesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListElasticsearchInstanceTypesRequest> {
        public Builder elasticsearchVersion(String var1);

        public Builder domainName(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

