/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig;

public class ElasticsearchClusterConfigUnmarshaller
implements Unmarshaller<ElasticsearchClusterConfig, JsonUnmarshallerContext> {
    private static final ElasticsearchClusterConfigUnmarshaller INSTANCE = new ElasticsearchClusterConfigUnmarshaller();

    public ElasticsearchClusterConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        ElasticsearchClusterConfig.Builder elasticsearchClusterConfigBuilder = ElasticsearchClusterConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("InstanceType", targetDepth)) {
                    context.nextToken();
                    elasticsearchClusterConfigBuilder.instanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceCount", targetDepth)) {
                    context.nextToken();
                    elasticsearchClusterConfigBuilder.instanceCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("DedicatedMasterEnabled", targetDepth)) {
                    context.nextToken();
                    elasticsearchClusterConfigBuilder.dedicatedMasterEnabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("ZoneAwarenessEnabled", targetDepth)) {
                    context.nextToken();
                    elasticsearchClusterConfigBuilder.zoneAwarenessEnabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("DedicatedMasterType", targetDepth)) {
                    context.nextToken();
                    elasticsearchClusterConfigBuilder.dedicatedMasterType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DedicatedMasterCount", targetDepth)) {
                    context.nextToken();
                    elasticsearchClusterConfigBuilder.dedicatedMasterCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ElasticsearchClusterConfig)elasticsearchClusterConfigBuilder.build();
    }

    public static ElasticsearchClusterConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

