/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.elasticsearch.model.Tag;
import software.amazon.awssdk.services.elasticsearch.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTagsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTagsResponse> {
    private final List<Tag> tagList;

    private ListTagsResponse(BuilderImpl builder) {
        this.tagList = builder.tagList;
    }

    public List<Tag> tagList() {
        return this.tagList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tagList() == null ? 0 : this.tagList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsResponse)) {
            return false;
        }
        ListTagsResponse other = (ListTagsResponse)((Object)obj);
        if (other.tagList() == null ^ this.tagList() == null) {
            return false;
        }
        return other.tagList() == null || other.tagList().equals(this.tagList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tagList() != null) {
            sb.append("TagList: ").append(this.tagList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagList": {
                return Optional.of(clazz.cast(this.tagList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Tag> tagList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsResponse model) {
            this.tagList(model.tagList);
        }

        public final Collection<Tag.Builder> getTagList() {
            return this.tagList != null ? (Collection)this.tagList.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        public ListTagsResponse build() {
            return new ListTagsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTagsResponse> {
        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);
    }
}

