/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.AccessPoliciesStatus;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfigStatus;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchVersionStatus;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptionsStatus;
import software.amazon.awssdk.services.elasticsearch.transform.ElasticsearchDomainConfigMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ElasticsearchDomainConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchDomainConfig> {
    private final ElasticsearchVersionStatus elasticsearchVersion;
    private final ElasticsearchClusterConfigStatus elasticsearchClusterConfig;
    private final EBSOptionsStatus ebsOptions;
    private final AccessPoliciesStatus accessPolicies;
    private final SnapshotOptionsStatus snapshotOptions;
    private final AdvancedOptionsStatus advancedOptions;

    private ElasticsearchDomainConfig(BuilderImpl builder) {
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.snapshotOptions = builder.snapshotOptions;
        this.advancedOptions = builder.advancedOptions;
    }

    public ElasticsearchVersionStatus elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public ElasticsearchClusterConfigStatus elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public EBSOptionsStatus ebsOptions() {
        return this.ebsOptions;
    }

    public AccessPoliciesStatus accessPolicies() {
        return this.accessPolicies;
    }

    public SnapshotOptionsStatus snapshotOptions() {
        return this.snapshotOptions;
    }

    public AdvancedOptionsStatus advancedOptions() {
        return this.advancedOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.elasticsearchVersion() == null ? 0 : this.elasticsearchVersion().hashCode());
        hashCode = 31 * hashCode + (this.elasticsearchClusterConfig() == null ? 0 : this.elasticsearchClusterConfig().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptions() == null ? 0 : this.ebsOptions().hashCode());
        hashCode = 31 * hashCode + (this.accessPolicies() == null ? 0 : this.accessPolicies().hashCode());
        hashCode = 31 * hashCode + (this.snapshotOptions() == null ? 0 : this.snapshotOptions().hashCode());
        hashCode = 31 * hashCode + (this.advancedOptions() == null ? 0 : this.advancedOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDomainConfig)) {
            return false;
        }
        ElasticsearchDomainConfig other = (ElasticsearchDomainConfig)obj;
        if (other.elasticsearchVersion() == null ^ this.elasticsearchVersion() == null) {
            return false;
        }
        if (other.elasticsearchVersion() != null && !other.elasticsearchVersion().equals(this.elasticsearchVersion())) {
            return false;
        }
        if (other.elasticsearchClusterConfig() == null ^ this.elasticsearchClusterConfig() == null) {
            return false;
        }
        if (other.elasticsearchClusterConfig() != null && !other.elasticsearchClusterConfig().equals(this.elasticsearchClusterConfig())) {
            return false;
        }
        if (other.ebsOptions() == null ^ this.ebsOptions() == null) {
            return false;
        }
        if (other.ebsOptions() != null && !other.ebsOptions().equals(this.ebsOptions())) {
            return false;
        }
        if (other.accessPolicies() == null ^ this.accessPolicies() == null) {
            return false;
        }
        if (other.accessPolicies() != null && !other.accessPolicies().equals(this.accessPolicies())) {
            return false;
        }
        if (other.snapshotOptions() == null ^ this.snapshotOptions() == null) {
            return false;
        }
        if (other.snapshotOptions() != null && !other.snapshotOptions().equals(this.snapshotOptions())) {
            return false;
        }
        if (other.advancedOptions() == null ^ this.advancedOptions() == null) {
            return false;
        }
        return other.advancedOptions() == null || other.advancedOptions().equals(this.advancedOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.elasticsearchVersion() != null) {
            sb.append("ElasticsearchVersion: ").append(this.elasticsearchVersion()).append(",");
        }
        if (this.elasticsearchClusterConfig() != null) {
            sb.append("ElasticsearchClusterConfig: ").append(this.elasticsearchClusterConfig()).append(",");
        }
        if (this.ebsOptions() != null) {
            sb.append("EBSOptions: ").append(this.ebsOptions()).append(",");
        }
        if (this.accessPolicies() != null) {
            sb.append("AccessPolicies: ").append(this.accessPolicies()).append(",");
        }
        if (this.snapshotOptions() != null) {
            sb.append("SnapshotOptions: ").append(this.snapshotOptions()).append(",");
        }
        if (this.advancedOptions() != null) {
            sb.append("AdvancedOptions: ").append(this.advancedOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticsearchVersion": {
                return Optional.of(clazz.cast(this.elasticsearchVersion()));
            }
            case "ElasticsearchClusterConfig": {
                return Optional.of(clazz.cast(this.elasticsearchClusterConfig()));
            }
            case "EBSOptions": {
                return Optional.of(clazz.cast(this.ebsOptions()));
            }
            case "AccessPolicies": {
                return Optional.of(clazz.cast(this.accessPolicies()));
            }
            case "SnapshotOptions": {
                return Optional.of(clazz.cast(this.snapshotOptions()));
            }
            case "AdvancedOptions": {
                return Optional.of(clazz.cast(this.advancedOptions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchDomainConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ElasticsearchVersionStatus elasticsearchVersion;
        private ElasticsearchClusterConfigStatus elasticsearchClusterConfig;
        private EBSOptionsStatus ebsOptions;
        private AccessPoliciesStatus accessPolicies;
        private SnapshotOptionsStatus snapshotOptions;
        private AdvancedOptionsStatus advancedOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDomainConfig model) {
            this.elasticsearchVersion(model.elasticsearchVersion);
            this.elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.accessPolicies(model.accessPolicies);
            this.snapshotOptions(model.snapshotOptions);
            this.advancedOptions(model.advancedOptions);
        }

        public final ElasticsearchVersionStatus.Builder getElasticsearchVersion() {
            return this.elasticsearchVersion != null ? this.elasticsearchVersion.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchVersion(ElasticsearchVersionStatus elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(ElasticsearchVersionStatus.BuilderImpl elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion != null ? elasticsearchVersion.build() : null;
        }

        public final ElasticsearchClusterConfigStatus.Builder getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfigStatus.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        public final EBSOptionsStatus.Builder getEBSOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptionsStatus ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final void setEBSOptions(EBSOptionsStatus.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        public final AccessPoliciesStatus.Builder getAccessPolicies() {
            return this.accessPolicies != null ? this.accessPolicies.toBuilder() : null;
        }

        @Override
        public final Builder accessPolicies(AccessPoliciesStatus accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(AccessPoliciesStatus.BuilderImpl accessPolicies) {
            this.accessPolicies = accessPolicies != null ? accessPolicies.build() : null;
        }

        public final SnapshotOptionsStatus.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptionsStatus snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final void setSnapshotOptions(SnapshotOptionsStatus.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        public final AdvancedOptionsStatus.Builder getAdvancedOptions() {
            return this.advancedOptions != null ? this.advancedOptions.toBuilder() : null;
        }

        @Override
        public final Builder advancedOptions(AdvancedOptionsStatus advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        public final void setAdvancedOptions(AdvancedOptionsStatus.BuilderImpl advancedOptions) {
            this.advancedOptions = advancedOptions != null ? advancedOptions.build() : null;
        }

        public ElasticsearchDomainConfig build() {
            return new ElasticsearchDomainConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchDomainConfig> {
        public Builder elasticsearchVersion(ElasticsearchVersionStatus var1);

        public Builder elasticsearchClusterConfig(ElasticsearchClusterConfigStatus var1);

        public Builder ebsOptions(EBSOptionsStatus var1);

        public Builder accessPolicies(AccessPoliciesStatus var1);

        public Builder snapshotOptions(SnapshotOptionsStatus var1);

        public Builder advancedOptions(AdvancedOptionsStatus var1);
    }
}

