/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.elasticsearch.model.DomainNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeElasticsearchDomainsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeElasticsearchDomainsRequest> {
    private final List<String> domainNames;

    private DescribeElasticsearchDomainsRequest(BuilderImpl builder) {
        this.domainNames = builder.domainNames;
    }

    public List<String> domainNames() {
        return this.domainNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainNames() == null ? 0 : this.domainNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchDomainsRequest)) {
            return false;
        }
        DescribeElasticsearchDomainsRequest other = (DescribeElasticsearchDomainsRequest)((Object)obj);
        if (other.domainNames() == null ^ this.domainNames() == null) {
            return false;
        }
        return other.domainNames() == null || other.domainNames().equals(this.domainNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainNames() != null) {
            sb.append("DomainNames: ").append(this.domainNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> domainNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchDomainsRequest model) {
            this.setDomainNames(model.domainNames);
        }

        public final Collection<String> getDomainNames() {
            return this.domainNames;
        }

        @Override
        public final Builder domainNames(Collection<String> domainNames) {
            this.domainNames = DomainNameListCopier.copy(domainNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainNames(String ... domainNames) {
            this.domainNames(Arrays.asList(domainNames));
            return this;
        }

        public final void setDomainNames(Collection<String> domainNames) {
            this.domainNames = DomainNameListCopier.copy(domainNames);
        }

        public DescribeElasticsearchDomainsRequest build() {
            return new DescribeElasticsearchDomainsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeElasticsearchDomainsRequest> {
        public Builder domainNames(Collection<String> var1);

        public Builder domainNames(String ... var1);
    }
}

