/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.StorageType;

@SdkInternalApi
public class StorageTypeMarshaller {
    private static final MarshallingInfo<String> STORAGETYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageTypeName").build();
    private static final MarshallingInfo<String> STORAGESUBTYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageSubTypeName").build();
    private static final MarshallingInfo<List> STORAGETYPELIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageTypeLimits").build();
    private static final StorageTypeMarshaller instance = new StorageTypeMarshaller();

    public static StorageTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(StorageType storageType, ProtocolMarshaller protocolMarshaller) {
        if (storageType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)storageType.storageTypeName(), STORAGETYPENAME_BINDING);
            protocolMarshaller.marshall((Object)storageType.storageSubTypeName(), STORAGESUBTYPENAME_BINDING);
            protocolMarshaller.marshall(storageType.storageTypeLimits(), STORAGETYPELIMITS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

