/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.VolumeType;
import software.amazon.awssdk.services.elasticsearch.transform.EBSOptionsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EBSOptions
implements StructuredPojo,
ToCopyableBuilder<Builder, EBSOptions> {
    private final Boolean ebsEnabled;
    private final String volumeType;
    private final Integer volumeSize;
    private final Integer iops;

    private EBSOptions(BuilderImpl builder) {
        this.ebsEnabled = builder.ebsEnabled;
        this.volumeType = builder.volumeType;
        this.volumeSize = builder.volumeSize;
        this.iops = builder.iops;
    }

    public Boolean ebsEnabled() {
        return this.ebsEnabled;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public Integer volumeSize() {
        return this.volumeSize;
    }

    public Integer iops() {
        return this.iops;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ebsEnabled() == null ? 0 : this.ebsEnabled().hashCode());
        hashCode = 31 * hashCode + (this.volumeType() == null ? 0 : this.volumeType().hashCode());
        hashCode = 31 * hashCode + (this.volumeSize() == null ? 0 : this.volumeSize().hashCode());
        hashCode = 31 * hashCode + (this.iops() == null ? 0 : this.iops().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EBSOptions)) {
            return false;
        }
        EBSOptions other = (EBSOptions)obj;
        if (other.ebsEnabled() == null ^ this.ebsEnabled() == null) {
            return false;
        }
        if (other.ebsEnabled() != null && !other.ebsEnabled().equals(this.ebsEnabled())) {
            return false;
        }
        if (other.volumeType() == null ^ this.volumeType() == null) {
            return false;
        }
        if (other.volumeType() != null && !other.volumeType().equals(this.volumeType())) {
            return false;
        }
        if (other.volumeSize() == null ^ this.volumeSize() == null) {
            return false;
        }
        if (other.volumeSize() != null && !other.volumeSize().equals(this.volumeSize())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        return other.iops() == null || other.iops().equals(this.iops());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ebsEnabled() != null) {
            sb.append("EBSEnabled: ").append(this.ebsEnabled()).append(",");
        }
        if (this.volumeType() != null) {
            sb.append("VolumeType: ").append(this.volumeType()).append(",");
        }
        if (this.volumeSize() != null) {
            sb.append("VolumeSize: ").append(this.volumeSize()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EBSOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean ebsEnabled;
        private String volumeType;
        private Integer volumeSize;
        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(EBSOptions model) {
            this.setEBSEnabled(model.ebsEnabled);
            this.setVolumeType(model.volumeType);
            this.setVolumeSize(model.volumeSize);
            this.setIops(model.iops);
        }

        public final Boolean getEBSEnabled() {
            return this.ebsEnabled;
        }

        @Override
        public final Builder ebsEnabled(Boolean ebsEnabled) {
            this.ebsEnabled = ebsEnabled;
            return this;
        }

        public final void setEBSEnabled(Boolean ebsEnabled) {
            this.ebsEnabled = ebsEnabled;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final void setVolumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public EBSOptions build() {
            return new EBSOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EBSOptions> {
        public Builder ebsEnabled(Boolean var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder volumeSize(Integer var1);

        public Builder iops(Integer var1);
    }
}

