/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.LimitValueListCopier;
import software.amazon.awssdk.services.elasticsearch.transform.AdditionalLimitMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AdditionalLimit
implements StructuredPojo,
ToCopyableBuilder<Builder, AdditionalLimit> {
    private final String limitName;
    private final List<String> limitValues;

    private AdditionalLimit(BuilderImpl builder) {
        this.limitName = builder.limitName;
        this.limitValues = builder.limitValues;
    }

    public String limitName() {
        return this.limitName;
    }

    public List<String> limitValues() {
        return this.limitValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.limitName() == null ? 0 : this.limitName().hashCode());
        hashCode = 31 * hashCode + (this.limitValues() == null ? 0 : this.limitValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalLimit)) {
            return false;
        }
        AdditionalLimit other = (AdditionalLimit)obj;
        if (other.limitName() == null ^ this.limitName() == null) {
            return false;
        }
        if (other.limitName() != null && !other.limitName().equals(this.limitName())) {
            return false;
        }
        if (other.limitValues() == null ^ this.limitValues() == null) {
            return false;
        }
        return other.limitValues() == null || other.limitValues().equals(this.limitValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.limitName() != null) {
            sb.append("LimitName: ").append(this.limitName()).append(",");
        }
        if (this.limitValues() != null) {
            sb.append("LimitValues: ").append(this.limitValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AdditionalLimitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String limitName;
        private List<String> limitValues;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalLimit model) {
            this.setLimitName(model.limitName);
            this.setLimitValues(model.limitValues);
        }

        public final String getLimitName() {
            return this.limitName;
        }

        @Override
        public final Builder limitName(String limitName) {
            this.limitName = limitName;
            return this;
        }

        public final void setLimitName(String limitName) {
            this.limitName = limitName;
        }

        public final Collection<String> getLimitValues() {
            return this.limitValues;
        }

        @Override
        public final Builder limitValues(Collection<String> limitValues) {
            this.limitValues = LimitValueListCopier.copy(limitValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitValues(String ... limitValues) {
            this.limitValues(Arrays.asList(limitValues));
            return this;
        }

        public final void setLimitValues(Collection<String> limitValues) {
            this.limitValues = LimitValueListCopier.copy(limitValues);
        }

        @SafeVarargs
        public final void setLimitValues(String ... limitValues) {
            this.limitValues(Arrays.asList(limitValues));
        }

        public AdditionalLimit build() {
            return new AdditionalLimit(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AdditionalLimit> {
        public Builder limitName(String var1);

        public Builder limitValues(Collection<String> var1);

        public Builder limitValues(String ... var1);
    }
}

