/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem;

public class UpgradeStepItemUnmarshaller
implements Unmarshaller<UpgradeStepItem, JsonUnmarshallerContext> {
    private static final UpgradeStepItemUnmarshaller INSTANCE = new UpgradeStepItemUnmarshaller();

    public UpgradeStepItem unmarshall(JsonUnmarshallerContext context) throws Exception {
        UpgradeStepItem.Builder upgradeStepItemBuilder = UpgradeStepItem.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("UpgradeStep", targetDepth)) {
                    context.nextToken();
                    upgradeStepItemBuilder.upgradeStep((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("UpgradeStepStatus", targetDepth)) {
                    context.nextToken();
                    upgradeStepItemBuilder.upgradeStepStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Issues", targetDepth)) {
                    context.nextToken();
                    upgradeStepItemBuilder.issues(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ProgressPercent", targetDepth)) {
                    context.nextToken();
                    upgradeStepItemBuilder.progressPercent((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (UpgradeStepItem)upgradeStepItemBuilder.build();
    }

    public static UpgradeStepItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}

