/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeStepItem;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpgradeStepItemMarshaller {
    private static final MarshallingInfo<String> UPGRADESTEP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpgradeStep").isBinary(false).build();
    private static final MarshallingInfo<String> UPGRADESTEPSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpgradeStepStatus").isBinary(false).build();
    private static final MarshallingInfo<List> ISSUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Issues").isBinary(false).build();
    private static final MarshallingInfo<Double> PROGRESSPERCENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProgressPercent").isBinary(false).build();
    private static final UpgradeStepItemMarshaller INSTANCE = new UpgradeStepItemMarshaller();

    private UpgradeStepItemMarshaller() {
    }

    public static UpgradeStepItemMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpgradeStepItem upgradeStepItem, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)upgradeStepItem, (String)"upgradeStepItem");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)upgradeStepItem.upgradeStepAsString(), UPGRADESTEP_BINDING);
            protocolMarshaller.marshall((Object)upgradeStepItem.upgradeStepStatusAsString(), UPGRADESTEPSTATUS_BINDING);
            protocolMarshaller.marshall(upgradeStepItem.issues(), ISSUES_BINDING);
            protocolMarshaller.marshall((Object)upgradeStepItem.progressPercent(), PROGRESSPERCENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

