/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeHistory;
import software.amazon.awssdk.services.elasticsearch.transform.UpgradeStepItemUnmarshaller;

public class UpgradeHistoryUnmarshaller
implements Unmarshaller<UpgradeHistory, JsonUnmarshallerContext> {
    private static final UpgradeHistoryUnmarshaller INSTANCE = new UpgradeHistoryUnmarshaller();

    public UpgradeHistory unmarshall(JsonUnmarshallerContext context) throws Exception {
        UpgradeHistory.Builder upgradeHistoryBuilder = UpgradeHistory.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("UpgradeName", targetDepth)) {
                    context.nextToken();
                    upgradeHistoryBuilder.upgradeName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StartTimestamp", targetDepth)) {
                    context.nextToken();
                    upgradeHistoryBuilder.startTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("UpgradeStatus", targetDepth)) {
                    context.nextToken();
                    upgradeHistoryBuilder.upgradeStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StepsList", targetDepth)) {
                    context.nextToken();
                    upgradeHistoryBuilder.stepsList(new ListUnmarshaller((Unmarshaller)UpgradeStepItemUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (UpgradeHistory)upgradeHistoryBuilder.build();
    }

    public static UpgradeHistoryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

