/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeHistory;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpgradeHistoryMarshaller {
    private static final MarshallingInfo<String> UPGRADENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpgradeName").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> UPGRADESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpgradeStatus").isBinary(false).build();
    private static final MarshallingInfo<List> STEPSLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepsList").isBinary(false).build();
    private static final UpgradeHistoryMarshaller INSTANCE = new UpgradeHistoryMarshaller();

    private UpgradeHistoryMarshaller() {
    }

    public static UpgradeHistoryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpgradeHistory upgradeHistory, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)upgradeHistory, (String)"upgradeHistory");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)upgradeHistory.upgradeName(), UPGRADENAME_BINDING);
            protocolMarshaller.marshall((Object)upgradeHistory.startTimestamp(), STARTTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)upgradeHistory.upgradeStatusAsString(), UPGRADESTATUS_BINDING);
            protocolMarshaller.marshall(upgradeHistory.stepsList(), STEPSLIST_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

