/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.StorageType;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StorageTypeMarshaller {
    private static final MarshallingInfo<String> STORAGETYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageTypeName").isBinary(false).build();
    private static final MarshallingInfo<String> STORAGESUBTYPENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageSubTypeName").isBinary(false).build();
    private static final MarshallingInfo<List> STORAGETYPELIMITS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageTypeLimits").isBinary(false).build();
    private static final StorageTypeMarshaller INSTANCE = new StorageTypeMarshaller();

    private StorageTypeMarshaller() {
    }

    public static StorageTypeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StorageType storageType, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)storageType, (String)"storageType");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)storageType.storageTypeName(), STORAGETYPENAME_BINDING);
            protocolMarshaller.marshall((Object)storageType.storageSubTypeName(), STORAGESUBTYPENAME_BINDING);
            protocolMarshaller.marshall(storageType.storageTypeLimits(), STORAGETYPELIMITS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

