/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReservedElasticsearchInstanceOfferingMarshaller {
    private static final MarshallingInfo<String> RESERVEDELASTICSEARCHINSTANCEOFFERINGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservedElasticsearchInstanceOfferingId").isBinary(false).build();
    private static final MarshallingInfo<String> ELASTICSEARCHINSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchInstanceType").isBinary(false).build();
    private static final MarshallingInfo<Integer> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").isBinary(false).build();
    private static final MarshallingInfo<Double> FIXEDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FixedPrice").isBinary(false).build();
    private static final MarshallingInfo<Double> USAGEPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UsagePrice").isBinary(false).build();
    private static final MarshallingInfo<String> CURRENCYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrencyCode").isBinary(false).build();
    private static final MarshallingInfo<String> PAYMENTOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PaymentOption").isBinary(false).build();
    private static final MarshallingInfo<List> RECURRINGCHARGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecurringCharges").isBinary(false).build();
    private static final ReservedElasticsearchInstanceOfferingMarshaller INSTANCE = new ReservedElasticsearchInstanceOfferingMarshaller();

    private ReservedElasticsearchInstanceOfferingMarshaller() {
    }

    public static ReservedElasticsearchInstanceOfferingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReservedElasticsearchInstanceOffering reservedElasticsearchInstanceOffering, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)reservedElasticsearchInstanceOffering, (String)"reservedElasticsearchInstanceOffering");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)reservedElasticsearchInstanceOffering.reservedElasticsearchInstanceOfferingId(), RESERVEDELASTICSEARCHINSTANCEOFFERINGID_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstanceOffering.elasticsearchInstanceTypeAsString(), ELASTICSEARCHINSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstanceOffering.duration(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstanceOffering.fixedPrice(), FIXEDPRICE_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstanceOffering.usagePrice(), USAGEPRICE_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstanceOffering.currencyCode(), CURRENCYCODE_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstanceOffering.paymentOptionAsString(), PAYMENTOPTION_BINDING);
            protocolMarshaller.marshall(reservedElasticsearchInstanceOffering.recurringCharges(), RECURRINGCHARGES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

