/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReservedElasticsearchInstanceMarshaller {
    private static final MarshallingInfo<String> RESERVATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservationName").isBinary(false).build();
    private static final MarshallingInfo<String> RESERVEDELASTICSEARCHINSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservedElasticsearchInstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> RESERVEDELASTICSEARCHINSTANCEOFFERINGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReservedElasticsearchInstanceOfferingId").isBinary(false).build();
    private static final MarshallingInfo<String> ELASTICSEARCHINSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchInstanceType").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").isBinary(false).build();
    private static final MarshallingInfo<Integer> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").isBinary(false).build();
    private static final MarshallingInfo<Double> FIXEDPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FixedPrice").isBinary(false).build();
    private static final MarshallingInfo<Double> USAGEPRICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UsagePrice").isBinary(false).build();
    private static final MarshallingInfo<String> CURRENCYCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrencyCode").isBinary(false).build();
    private static final MarshallingInfo<Integer> ELASTICSEARCHINSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchInstanceCount").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").isBinary(false).build();
    private static final MarshallingInfo<String> PAYMENTOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PaymentOption").isBinary(false).build();
    private static final MarshallingInfo<List> RECURRINGCHARGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecurringCharges").isBinary(false).build();
    private static final ReservedElasticsearchInstanceMarshaller INSTANCE = new ReservedElasticsearchInstanceMarshaller();

    private ReservedElasticsearchInstanceMarshaller() {
    }

    public static ReservedElasticsearchInstanceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReservedElasticsearchInstance reservedElasticsearchInstance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)reservedElasticsearchInstance, (String)"reservedElasticsearchInstance");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.reservationName(), RESERVATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.reservedElasticsearchInstanceId(), RESERVEDELASTICSEARCHINSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.reservedElasticsearchInstanceOfferingId(), RESERVEDELASTICSEARCHINSTANCEOFFERINGID_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.elasticsearchInstanceTypeAsString(), ELASTICSEARCHINSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.duration(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.fixedPrice(), FIXEDPRICE_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.usagePrice(), USAGEPRICE_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.currencyCode(), CURRENCYCODE_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.elasticsearchInstanceCount(), ELASTICSEARCHINSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.state(), STATE_BINDING);
            protocolMarshaller.marshall((Object)reservedElasticsearchInstance.paymentOptionAsString(), PAYMENTOPTION_BINDING);
            protocolMarshaller.marshall(reservedElasticsearchInstance.recurringCharges(), RECURRINGCHARGES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

