/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.RecurringCharge;

public class RecurringChargeUnmarshaller
implements Unmarshaller<RecurringCharge, JsonUnmarshallerContext> {
    private static final RecurringChargeUnmarshaller INSTANCE = new RecurringChargeUnmarshaller();

    public RecurringCharge unmarshall(JsonUnmarshallerContext context) throws Exception {
        RecurringCharge.Builder recurringChargeBuilder = RecurringCharge.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("RecurringChargeAmount", targetDepth)) {
                    context.nextToken();
                    recurringChargeBuilder.recurringChargeAmount((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("RecurringChargeFrequency", targetDepth)) {
                    context.nextToken();
                    recurringChargeBuilder.recurringChargeFrequency((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (RecurringCharge)recurringChargeBuilder.build();
    }

    public static RecurringChargeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

