/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.RecurringCharge;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RecurringChargeMarshaller {
    private static final MarshallingInfo<Double> RECURRINGCHARGEAMOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecurringChargeAmount").isBinary(false).build();
    private static final MarshallingInfo<String> RECURRINGCHARGEFREQUENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecurringChargeFrequency").isBinary(false).build();
    private static final RecurringChargeMarshaller INSTANCE = new RecurringChargeMarshaller();

    private RecurringChargeMarshaller() {
    }

    public static RecurringChargeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RecurringCharge recurringCharge, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)recurringCharge, (String)"recurringCharge");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)recurringCharge.recurringChargeAmount(), RECURRINGCHARGEAMOUNT_BINDING);
            protocolMarshaller.marshall((Object)recurringCharge.recurringChargeFrequency(), RECURRINGCHARGEFREQUENCY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

