/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.EncryptionAtRestOptions;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EncryptionAtRestOptionsMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").isBinary(false).build();
    private static final EncryptionAtRestOptionsMarshaller INSTANCE = new EncryptionAtRestOptionsMarshaller();

    private EncryptionAtRestOptionsMarshaller() {
    }

    public static EncryptionAtRestOptionsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EncryptionAtRestOptions encryptionAtRestOptions, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)encryptionAtRestOptions, (String)"encryptionAtRestOptions");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)encryptionAtRestOptions.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)encryptionAtRestOptions.kmsKeyId(), KMSKEYID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

