/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchDomainStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ElasticsearchDomainStatusMarshaller {
    private static final MarshallingInfo<String> DOMAINID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainId").isBinary(false).build();
    private static final MarshallingInfo<String> DOMAINNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainName").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ARN").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CREATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Created").isBinary(false).build();
    private static final MarshallingInfo<Boolean> DELETED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Deleted").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Endpoint").isBinary(false).build();
    private static final MarshallingInfo<Map> ENDPOINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Endpoints").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PROCESSING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Processing").isBinary(false).build();
    private static final MarshallingInfo<Boolean> UPGRADEPROCESSING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpgradeProcessing").isBinary(false).build();
    private static final MarshallingInfo<String> ELASTICSEARCHVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchVersion").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ELASTICSEARCHCLUSTERCONFIG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ElasticsearchClusterConfig").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EBSOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EBSOptions").isBinary(false).build();
    private static final MarshallingInfo<String> ACCESSPOLICIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessPolicies").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SNAPSHOTOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotOptions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> VPCOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VPCOptions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COGNITOOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CognitoOptions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENCRYPTIONATRESTOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EncryptionAtRestOptions").isBinary(false).build();
    private static final MarshallingInfo<Map> ADVANCEDOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdvancedOptions").isBinary(false).build();
    private static final MarshallingInfo<Map> LOGPUBLISHINGOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogPublishingOptions").isBinary(false).build();
    private static final ElasticsearchDomainStatusMarshaller INSTANCE = new ElasticsearchDomainStatusMarshaller();

    private ElasticsearchDomainStatusMarshaller() {
    }

    public static ElasticsearchDomainStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchDomainStatus elasticsearchDomainStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)elasticsearchDomainStatus, (String)"elasticsearchDomainStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.domainId(), DOMAINID_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.domainName(), DOMAINNAME_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.created(), CREATED_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.deleted(), DELETED_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.endpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall(elasticsearchDomainStatus.endpoints(), ENDPOINTS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.processing(), PROCESSING_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.upgradeProcessing(), UPGRADEPROCESSING_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.elasticsearchVersion(), ELASTICSEARCHVERSION_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.elasticsearchClusterConfig(), ELASTICSEARCHCLUSTERCONFIG_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.ebsOptions(), EBSOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.accessPolicies(), ACCESSPOLICIES_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.snapshotOptions(), SNAPSHOTOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.vpcOptions(), VPCOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.cognitoOptions(), COGNITOOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchDomainStatus.encryptionAtRestOptions(), ENCRYPTIONATRESTOPTIONS_BINDING);
            protocolMarshaller.marshall(elasticsearchDomainStatus.advancedOptions(), ADVANCEDOPTIONS_BINDING);
            protocolMarshaller.marshall(elasticsearchDomainStatus.logPublishingOptionsAsStrings(), LOGPUBLISHINGOPTIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

