/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.CompatibleVersionsMap;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CompatibleVersionsMapMarshaller {
    private static final MarshallingInfo<String> SOURCEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceVersion").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetVersions").isBinary(false).build();
    private static final CompatibleVersionsMapMarshaller INSTANCE = new CompatibleVersionsMapMarshaller();

    private CompatibleVersionsMapMarshaller() {
    }

    public static CompatibleVersionsMapMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CompatibleVersionsMap compatibleVersionsMap, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)compatibleVersionsMap, (String)"compatibleVersionsMap");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)compatibleVersionsMap.sourceVersion(), SOURCEVERSION_BINDING);
            protocolMarshaller.marshall(compatibleVersionsMap.targetVersions(), TARGETVERSIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

