/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.elasticsearch.model.CognitoOptions;

public class CognitoOptionsUnmarshaller
implements Unmarshaller<CognitoOptions, JsonUnmarshallerContext> {
    private static final CognitoOptionsUnmarshaller INSTANCE = new CognitoOptionsUnmarshaller();

    public CognitoOptions unmarshall(JsonUnmarshallerContext context) throws Exception {
        CognitoOptions.Builder cognitoOptionsBuilder = CognitoOptions.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Enabled", targetDepth)) {
                    context.nextToken();
                    cognitoOptionsBuilder.enabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("UserPoolId", targetDepth)) {
                    context.nextToken();
                    cognitoOptionsBuilder.userPoolId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("IdentityPoolId", targetDepth)) {
                    context.nextToken();
                    cognitoOptionsBuilder.identityPoolId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RoleArn", targetDepth)) {
                    context.nextToken();
                    cognitoOptionsBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CognitoOptions)cognitoOptionsBuilder.build();
    }

    public static CognitoOptionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

