/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.CognitoOptions;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CognitoOptionsMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<String> USERPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> IDENTITYPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final CognitoOptionsMarshaller INSTANCE = new CognitoOptionsMarshaller();

    private CognitoOptionsMarshaller() {
    }

    public static CognitoOptionsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CognitoOptions cognitoOptions, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)cognitoOptions, (String)"cognitoOptions");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)cognitoOptions.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)cognitoOptions.userPoolId(), USERPOOLID_BINDING);
            protocolMarshaller.marshall((Object)cognitoOptions.identityPoolId(), IDENTITYPOOLID_BINDING);
            protocolMarshaller.marshall((Object)cognitoOptions.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

