/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.elasticsearch.model.AdditionalLimit;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AdditionalLimitMarshaller {
    private static final MarshallingInfo<String> LIMITNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LimitName").isBinary(false).build();
    private static final MarshallingInfo<List> LIMITVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LimitValues").isBinary(false).build();
    private static final AdditionalLimitMarshaller INSTANCE = new AdditionalLimitMarshaller();

    private AdditionalLimitMarshaller() {
    }

    public static AdditionalLimitMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AdditionalLimit additionalLimit, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)additionalLimit, (String)"additionalLimit");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)additionalLimit.limitName(), LIMITNAME_BINDING);
            protocolMarshaller.marshall(additionalLimit.limitValues(), LIMITVALUES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

