/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.IssuesCopier;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeStatus;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeStep;
import software.amazon.awssdk.services.elasticsearch.transform.UpgradeStepItemMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeStepItem
implements StructuredPojo,
ToCopyableBuilder<Builder, UpgradeStepItem> {
    private final String upgradeStep;
    private final String upgradeStepStatus;
    private final List<String> issues;
    private final Double progressPercent;

    private UpgradeStepItem(BuilderImpl builder) {
        this.upgradeStep = builder.upgradeStep;
        this.upgradeStepStatus = builder.upgradeStepStatus;
        this.issues = builder.issues;
        this.progressPercent = builder.progressPercent;
    }

    public UpgradeStep upgradeStep() {
        return UpgradeStep.fromValue(this.upgradeStep);
    }

    public String upgradeStepAsString() {
        return this.upgradeStep;
    }

    public UpgradeStatus upgradeStepStatus() {
        return UpgradeStatus.fromValue(this.upgradeStepStatus);
    }

    public String upgradeStepStatusAsString() {
        return this.upgradeStepStatus;
    }

    public List<String> issues() {
        return this.issues;
    }

    public Double progressPercent() {
        return this.progressPercent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeStepAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeStepStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.issues());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeStepItem)) {
            return false;
        }
        UpgradeStepItem other = (UpgradeStepItem)obj;
        return Objects.equals(this.upgradeStepAsString(), other.upgradeStepAsString()) && Objects.equals(this.upgradeStepStatusAsString(), other.upgradeStepStatusAsString()) && Objects.equals(this.issues(), other.issues()) && Objects.equals(this.progressPercent(), other.progressPercent());
    }

    public String toString() {
        return ToString.builder((String)"UpgradeStepItem").add("UpgradeStep", (Object)this.upgradeStepAsString()).add("UpgradeStepStatus", (Object)this.upgradeStepStatusAsString()).add("Issues", this.issues()).add("ProgressPercent", (Object)this.progressPercent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpgradeStep": {
                return Optional.ofNullable(clazz.cast(this.upgradeStepAsString()));
            }
            case "UpgradeStepStatus": {
                return Optional.ofNullable(clazz.cast(this.upgradeStepStatusAsString()));
            }
            case "Issues": {
                return Optional.ofNullable(clazz.cast(this.issues()));
            }
            case "ProgressPercent": {
                return Optional.ofNullable(clazz.cast(this.progressPercent()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpgradeStepItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String upgradeStep;
        private String upgradeStepStatus;
        private List<String> issues = DefaultSdkAutoConstructList.getInstance();
        private Double progressPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeStepItem model) {
            this.upgradeStep(model.upgradeStep);
            this.upgradeStepStatus(model.upgradeStepStatus);
            this.issues(model.issues);
            this.progressPercent(model.progressPercent);
        }

        public final String getUpgradeStep() {
            return this.upgradeStep;
        }

        @Override
        public final Builder upgradeStep(String upgradeStep) {
            this.upgradeStep = upgradeStep;
            return this;
        }

        @Override
        public final Builder upgradeStep(UpgradeStep upgradeStep) {
            this.upgradeStep(upgradeStep.toString());
            return this;
        }

        public final void setUpgradeStep(String upgradeStep) {
            this.upgradeStep = upgradeStep;
        }

        public final String getUpgradeStepStatus() {
            return this.upgradeStepStatus;
        }

        @Override
        public final Builder upgradeStepStatus(String upgradeStepStatus) {
            this.upgradeStepStatus = upgradeStepStatus;
            return this;
        }

        @Override
        public final Builder upgradeStepStatus(UpgradeStatus upgradeStepStatus) {
            this.upgradeStepStatus(upgradeStepStatus.toString());
            return this;
        }

        public final void setUpgradeStepStatus(String upgradeStepStatus) {
            this.upgradeStepStatus = upgradeStepStatus;
        }

        public final Collection<String> getIssues() {
            return this.issues;
        }

        @Override
        public final Builder issues(Collection<String> issues) {
            this.issues = IssuesCopier.copy(issues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(String ... issues) {
            this.issues(Arrays.asList(issues));
            return this;
        }

        public final void setIssues(Collection<String> issues) {
            this.issues = IssuesCopier.copy(issues);
        }

        public final Double getProgressPercent() {
            return this.progressPercent;
        }

        @Override
        public final Builder progressPercent(Double progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final void setProgressPercent(Double progressPercent) {
            this.progressPercent = progressPercent;
        }

        public UpgradeStepItem build() {
            return new UpgradeStepItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpgradeStepItem> {
        public Builder upgradeStep(String var1);

        public Builder upgradeStep(UpgradeStep var1);

        public Builder upgradeStepStatus(String var1);

        public Builder upgradeStepStatus(UpgradeStatus var1);

        public Builder issues(Collection<String> var1);

        public Builder issues(String ... var1);

        public Builder progressPercent(Double var1);
    }
}

