/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeElasticsearchDomainResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, UpgradeElasticsearchDomainResponse> {
    private final String domainName;
    private final String targetVersion;
    private final Boolean performCheckOnly;

    private UpgradeElasticsearchDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.targetVersion = builder.targetVersion;
        this.performCheckOnly = builder.performCheckOnly;
    }

    public String domainName() {
        return this.domainName;
    }

    public String targetVersion() {
        return this.targetVersion;
    }

    public Boolean performCheckOnly() {
        return this.performCheckOnly;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.performCheckOnly());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeElasticsearchDomainResponse)) {
            return false;
        }
        UpgradeElasticsearchDomainResponse other = (UpgradeElasticsearchDomainResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.performCheckOnly(), other.performCheckOnly());
    }

    public String toString() {
        return ToString.builder((String)"UpgradeElasticsearchDomainResponse").add("DomainName", (Object)this.domainName()).add("TargetVersion", (Object)this.targetVersion()).add("PerformCheckOnly", (Object)this.performCheckOnly()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "TargetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "PerformCheckOnly": {
                return Optional.ofNullable(clazz.cast(this.performCheckOnly()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private String targetVersion;
        private Boolean performCheckOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeElasticsearchDomainResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.targetVersion(model.targetVersion);
            this.performCheckOnly(model.performCheckOnly);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getTargetVersion() {
            return this.targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        public final Boolean getPerformCheckOnly() {
            return this.performCheckOnly;
        }

        @Override
        public final Builder performCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
            return this;
        }

        public final void setPerformCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
        }

        @Override
        public UpgradeElasticsearchDomainResponse build() {
            return new UpgradeElasticsearchDomainResponse(this);
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    CopyableBuilder<Builder, UpgradeElasticsearchDomainResponse> {
        public Builder domainName(String var1);

        public Builder targetVersion(String var1);

        public Builder performCheckOnly(Boolean var1);
    }
}

