/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.elasticsearch.model.AdvancedOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.CognitoOptions;
import software.amazon.awssdk.services.elasticsearch.model.EBSOptions;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOption;
import software.amazon.awssdk.services.elasticsearch.model.LogPublishingOptionsCopier;
import software.amazon.awssdk.services.elasticsearch.model.LogType;
import software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions;
import software.amazon.awssdk.services.elasticsearch.model.VPCOptions;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateElasticsearchDomainConfigRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, UpdateElasticsearchDomainConfigRequest> {
    private final String domainName;
    private final ElasticsearchClusterConfig elasticsearchClusterConfig;
    private final EBSOptions ebsOptions;
    private final SnapshotOptions snapshotOptions;
    private final VPCOptions vpcOptions;
    private final CognitoOptions cognitoOptions;
    private final Map<String, String> advancedOptions;
    private final String accessPolicies;
    private final Map<String, LogPublishingOption> logPublishingOptions;

    private UpdateElasticsearchDomainConfigRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.advancedOptions = builder.advancedOptions;
        this.accessPolicies = builder.accessPolicies;
        this.logPublishingOptions = builder.logPublishingOptions;
    }

    public String domainName() {
        return this.domainName;
    }

    public ElasticsearchClusterConfig elasticsearchClusterConfig() {
        return this.elasticsearchClusterConfig;
    }

    public EBSOptions ebsOptions() {
        return this.ebsOptions;
    }

    public SnapshotOptions snapshotOptions() {
        return this.snapshotOptions;
    }

    public VPCOptions vpcOptions() {
        return this.vpcOptions;
    }

    public CognitoOptions cognitoOptions() {
        return this.cognitoOptions;
    }

    public Map<String, String> advancedOptions() {
        return this.advancedOptions;
    }

    public String accessPolicies() {
        return this.accessPolicies;
    }

    public Map<LogType, LogPublishingOption> logPublishingOptions() {
        return TypeConverter.convert(this.logPublishingOptions, LogType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)LogType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, LogPublishingOption> logPublishingOptionsAsStrings() {
        return this.logPublishingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchClusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPublishingOptionsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateElasticsearchDomainConfigRequest)) {
            return false;
        }
        UpdateElasticsearchDomainConfigRequest other = (UpdateElasticsearchDomainConfigRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.elasticsearchClusterConfig(), other.elasticsearchClusterConfig()) && Objects.equals(this.ebsOptions(), other.ebsOptions()) && Objects.equals(this.snapshotOptions(), other.snapshotOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.cognitoOptions(), other.cognitoOptions()) && Objects.equals(this.advancedOptions(), other.advancedOptions()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.logPublishingOptionsAsStrings(), other.logPublishingOptionsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"UpdateElasticsearchDomainConfigRequest").add("DomainName", (Object)this.domainName()).add("ElasticsearchClusterConfig", (Object)this.elasticsearchClusterConfig()).add("EBSOptions", (Object)this.ebsOptions()).add("SnapshotOptions", (Object)this.snapshotOptions()).add("VPCOptions", (Object)this.vpcOptions()).add("CognitoOptions", (Object)this.cognitoOptions()).add("AdvancedOptions", this.advancedOptions()).add("AccessPolicies", (Object)this.accessPolicies()).add("LogPublishingOptions", this.logPublishingOptionsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ElasticsearchClusterConfig": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchClusterConfig()));
            }
            case "EBSOptions": {
                return Optional.ofNullable(clazz.cast(this.ebsOptions()));
            }
            case "SnapshotOptions": {
                return Optional.ofNullable(clazz.cast(this.snapshotOptions()));
            }
            case "VPCOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "CognitoOptions": {
                return Optional.ofNullable(clazz.cast(this.cognitoOptions()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private ElasticsearchClusterConfig elasticsearchClusterConfig;
        private EBSOptions ebsOptions;
        private SnapshotOptions snapshotOptions;
        private VPCOptions vpcOptions;
        private CognitoOptions cognitoOptions;
        private Map<String, String> advancedOptions = DefaultSdkAutoConstructMap.getInstance();
        private String accessPolicies;
        private Map<String, LogPublishingOption> logPublishingOptions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateElasticsearchDomainConfigRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.snapshotOptions(model.snapshotOptions);
            this.vpcOptions(model.vpcOptions);
            this.cognitoOptions(model.cognitoOptions);
            this.advancedOptions(model.advancedOptions);
            this.accessPolicies(model.accessPolicies);
            this.logPublishingOptionsWithStrings(model.logPublishingOptions);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final ElasticsearchClusterConfig.Builder getElasticsearchClusterConfig() {
            return this.elasticsearchClusterConfig != null ? this.elasticsearchClusterConfig.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearchClusterConfig(ElasticsearchClusterConfig elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final void setElasticsearchClusterConfig(ElasticsearchClusterConfig.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        public final EBSOptions.Builder getEBSOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptions ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final void setEBSOptions(EBSOptions.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        public final SnapshotOptions.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptions snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final void setSnapshotOptions(SnapshotOptions.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        public final VPCOptions.Builder getVPCOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        @Override
        public final Builder vpcOptions(VPCOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final void setVPCOptions(VPCOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        public final CognitoOptions.Builder getCognitoOptions() {
            return this.cognitoOptions != null ? this.cognitoOptions.toBuilder() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptions cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final void setCognitoOptions(CognitoOptions.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        public final Map<String, String> getAdvancedOptions() {
            return this.advancedOptions;
        }

        @Override
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        public final Map<String, LogPublishingOption.Builder> getLogPublishingOptions() {
            return this.logPublishingOptions != null ? CollectionUtils.mapValues(this.logPublishingOptions, LogPublishingOption::toBuilder) : null;
        }

        @Override
        public final Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copy(logPublishingOptions);
            return this;
        }

        @Override
        public final Builder logPublishingOptions(Map<LogType, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyEnumToString(logPublishingOptions);
            return this;
        }

        public final void setLogPublishingOptions(Map<String, LogPublishingOption.BuilderImpl> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyFromBuilder(logPublishingOptions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateElasticsearchDomainConfigRequest build() {
            return new UpdateElasticsearchDomainConfigRequest(this);
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    CopyableBuilder<Builder, UpdateElasticsearchDomainConfigRequest> {
        public Builder domainName(String var1);

        public Builder elasticsearchClusterConfig(ElasticsearchClusterConfig var1);

        default public Builder elasticsearchClusterConfig(Consumer<ElasticsearchClusterConfig.Builder> elasticsearchClusterConfig) {
            return this.elasticsearchClusterConfig((ElasticsearchClusterConfig)((ElasticsearchClusterConfig.Builder)ElasticsearchClusterConfig.builder().applyMutation(elasticsearchClusterConfig)).build());
        }

        public Builder ebsOptions(EBSOptions var1);

        default public Builder ebsOptions(Consumer<EBSOptions.Builder> ebsOptions) {
            return this.ebsOptions((EBSOptions)((EBSOptions.Builder)EBSOptions.builder().applyMutation(ebsOptions)).build());
        }

        public Builder snapshotOptions(SnapshotOptions var1);

        default public Builder snapshotOptions(Consumer<SnapshotOptions.Builder> snapshotOptions) {
            return this.snapshotOptions((SnapshotOptions)((SnapshotOptions.Builder)SnapshotOptions.builder().applyMutation(snapshotOptions)).build());
        }

        public Builder vpcOptions(VPCOptions var1);

        default public Builder vpcOptions(Consumer<VPCOptions.Builder> vpcOptions) {
            return this.vpcOptions((VPCOptions)((VPCOptions.Builder)VPCOptions.builder().applyMutation(vpcOptions)).build());
        }

        public Builder cognitoOptions(CognitoOptions var1);

        default public Builder cognitoOptions(Consumer<CognitoOptions.Builder> cognitoOptions) {
            return this.cognitoOptions((CognitoOptions)((CognitoOptions.Builder)CognitoOptions.builder().applyMutation(cognitoOptions)).build());
        }

        public Builder advancedOptions(Map<String, String> var1);

        public Builder accessPolicies(String var1);

        public Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> var1);

        public Builder logPublishingOptions(Map<LogType, LogPublishingOption> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

