/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ESPartitionInstanceType;
import software.amazon.awssdk.services.elasticsearch.model.RecurringCharge;
import software.amazon.awssdk.services.elasticsearch.model.RecurringChargeListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstancePaymentOption;
import software.amazon.awssdk.services.elasticsearch.transform.ReservedElasticsearchInstanceOfferingMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedElasticsearchInstanceOffering
implements StructuredPojo,
ToCopyableBuilder<Builder, ReservedElasticsearchInstanceOffering> {
    private final String reservedElasticsearchInstanceOfferingId;
    private final String elasticsearchInstanceType;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final String currencyCode;
    private final String paymentOption;
    private final List<RecurringCharge> recurringCharges;

    private ReservedElasticsearchInstanceOffering(BuilderImpl builder) {
        this.reservedElasticsearchInstanceOfferingId = builder.reservedElasticsearchInstanceOfferingId;
        this.elasticsearchInstanceType = builder.elasticsearchInstanceType;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.paymentOption = builder.paymentOption;
        this.recurringCharges = builder.recurringCharges;
    }

    public String reservedElasticsearchInstanceOfferingId() {
        return this.reservedElasticsearchInstanceOfferingId;
    }

    public ESPartitionInstanceType elasticsearchInstanceType() {
        return ESPartitionInstanceType.fromValue(this.elasticsearchInstanceType);
    }

    public String elasticsearchInstanceTypeAsString() {
        return this.elasticsearchInstanceType;
    }

    public Integer duration() {
        return this.duration;
    }

    public Double fixedPrice() {
        return this.fixedPrice;
    }

    public Double usagePrice() {
        return this.usagePrice;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public ReservedElasticsearchInstancePaymentOption paymentOption() {
        return ReservedElasticsearchInstancePaymentOption.fromValue(this.paymentOption);
    }

    public String paymentOptionAsString() {
        return this.paymentOption;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedElasticsearchInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurringCharges());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedElasticsearchInstanceOffering)) {
            return false;
        }
        ReservedElasticsearchInstanceOffering other = (ReservedElasticsearchInstanceOffering)obj;
        return Objects.equals(this.reservedElasticsearchInstanceOfferingId(), other.reservedElasticsearchInstanceOfferingId()) && Objects.equals(this.elasticsearchInstanceTypeAsString(), other.elasticsearchInstanceTypeAsString()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.usagePrice(), other.usagePrice()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.recurringCharges(), other.recurringCharges());
    }

    public String toString() {
        return ToString.builder((String)"ReservedElasticsearchInstanceOffering").add("ReservedElasticsearchInstanceOfferingId", (Object)this.reservedElasticsearchInstanceOfferingId()).add("ElasticsearchInstanceType", (Object)this.elasticsearchInstanceTypeAsString()).add("Duration", (Object)this.duration()).add("FixedPrice", (Object)this.fixedPrice()).add("UsagePrice", (Object)this.usagePrice()).add("CurrencyCode", (Object)this.currencyCode()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("RecurringCharges", this.recurringCharges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedElasticsearchInstanceOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedElasticsearchInstanceOfferingId()));
            }
            case "ElasticsearchInstanceType": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchInstanceTypeAsString()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "RecurringCharges": {
                return Optional.ofNullable(clazz.cast(this.recurringCharges()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReservedElasticsearchInstanceOfferingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String reservedElasticsearchInstanceOfferingId;
        private String elasticsearchInstanceType;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private String currencyCode;
        private String paymentOption;
        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedElasticsearchInstanceOffering model) {
            this.reservedElasticsearchInstanceOfferingId(model.reservedElasticsearchInstanceOfferingId);
            this.elasticsearchInstanceType(model.elasticsearchInstanceType);
            this.duration(model.duration);
            this.fixedPrice(model.fixedPrice);
            this.usagePrice(model.usagePrice);
            this.currencyCode(model.currencyCode);
            this.paymentOption(model.paymentOption);
            this.recurringCharges(model.recurringCharges);
        }

        public final String getReservedElasticsearchInstanceOfferingId() {
            return this.reservedElasticsearchInstanceOfferingId;
        }

        @Override
        public final Builder reservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
            return this;
        }

        public final void setReservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
        }

        public final String getElasticsearchInstanceType() {
            return this.elasticsearchInstanceType;
        }

        @Override
        public final Builder elasticsearchInstanceType(String elasticsearchInstanceType) {
            this.elasticsearchInstanceType = elasticsearchInstanceType;
            return this;
        }

        @Override
        public final Builder elasticsearchInstanceType(ESPartitionInstanceType elasticsearchInstanceType) {
            this.elasticsearchInstanceType(elasticsearchInstanceType.toString());
            return this;
        }

        public final void setElasticsearchInstanceType(String elasticsearchInstanceType) {
            this.elasticsearchInstanceType = elasticsearchInstanceType;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getPaymentOption() {
            return this.paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(ReservedElasticsearchInstancePaymentOption paymentOption) {
            this.paymentOption(paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final Collection<RecurringCharge.Builder> getRecurringCharges() {
            return this.recurringCharges != null ? (Collection)this.recurringCharges.stream().map(RecurringCharge::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder> ... recurringCharges) {
            this.recurringCharges(Stream.of(recurringCharges).map(c -> (RecurringCharge)((RecurringCharge.Builder)RecurringCharge.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        public ReservedElasticsearchInstanceOffering build() {
            return new ReservedElasticsearchInstanceOffering(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedElasticsearchInstanceOffering> {
        public Builder reservedElasticsearchInstanceOfferingId(String var1);

        public Builder elasticsearchInstanceType(String var1);

        public Builder elasticsearchInstanceType(ESPartitionInstanceType var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder currencyCode(String var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(ReservedElasticsearchInstancePaymentOption var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);

        public Builder recurringCharges(Consumer<RecurringCharge.Builder> ... var1);
    }
}

