/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseReservedElasticsearchInstanceOfferingRequest
extends ElasticsearchRequest
implements ToCopyableBuilder<Builder, PurchaseReservedElasticsearchInstanceOfferingRequest> {
    private final String reservedElasticsearchInstanceOfferingId;
    private final String reservationName;
    private final Integer instanceCount;

    private PurchaseReservedElasticsearchInstanceOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedElasticsearchInstanceOfferingId = builder.reservedElasticsearchInstanceOfferingId;
        this.reservationName = builder.reservationName;
        this.instanceCount = builder.instanceCount;
    }

    public String reservedElasticsearchInstanceOfferingId() {
        return this.reservedElasticsearchInstanceOfferingId;
    }

    public String reservationName() {
        return this.reservationName;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedElasticsearchInstanceOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedElasticsearchInstanceOfferingRequest)) {
            return false;
        }
        PurchaseReservedElasticsearchInstanceOfferingRequest other = (PurchaseReservedElasticsearchInstanceOfferingRequest)((Object)obj);
        return Objects.equals(this.reservedElasticsearchInstanceOfferingId(), other.reservedElasticsearchInstanceOfferingId()) && Objects.equals(this.reservationName(), other.reservationName()) && Objects.equals(this.instanceCount(), other.instanceCount());
    }

    public String toString() {
        return ToString.builder((String)"PurchaseReservedElasticsearchInstanceOfferingRequest").add("ReservedElasticsearchInstanceOfferingId", (Object)this.reservedElasticsearchInstanceOfferingId()).add("ReservationName", (Object)this.reservationName()).add("InstanceCount", (Object)this.instanceCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedElasticsearchInstanceOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedElasticsearchInstanceOfferingId()));
            }
            case "ReservationName": {
                return Optional.ofNullable(clazz.cast(this.reservationName()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticsearchRequest.BuilderImpl
    implements Builder {
        private String reservedElasticsearchInstanceOfferingId;
        private String reservationName;
        private Integer instanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedElasticsearchInstanceOfferingRequest model) {
            super(model);
            this.reservedElasticsearchInstanceOfferingId(model.reservedElasticsearchInstanceOfferingId);
            this.reservationName(model.reservationName);
            this.instanceCount(model.instanceCount);
        }

        public final String getReservedElasticsearchInstanceOfferingId() {
            return this.reservedElasticsearchInstanceOfferingId;
        }

        @Override
        public final Builder reservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
            return this;
        }

        public final void setReservedElasticsearchInstanceOfferingId(String reservedElasticsearchInstanceOfferingId) {
            this.reservedElasticsearchInstanceOfferingId = reservedElasticsearchInstanceOfferingId;
        }

        public final String getReservationName() {
            return this.reservationName;
        }

        @Override
        public final Builder reservationName(String reservationName) {
            this.reservationName = reservationName;
            return this;
        }

        public final void setReservationName(String reservationName) {
            this.reservationName = reservationName;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedElasticsearchInstanceOfferingRequest build() {
            return new PurchaseReservedElasticsearchInstanceOfferingRequest(this);
        }
    }

    public static interface Builder
    extends ElasticsearchRequest.Builder,
    CopyableBuilder<Builder, PurchaseReservedElasticsearchInstanceOfferingRequest> {
        public Builder reservedElasticsearchInstanceOfferingId(String var1);

        public Builder reservationName(String var1);

        public Builder instanceCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

