/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.AdditionalLimit;
import software.amazon.awssdk.services.elasticsearch.model.AdditionalLimitListCopier;
import software.amazon.awssdk.services.elasticsearch.model.InstanceLimits;
import software.amazon.awssdk.services.elasticsearch.model.StorageType;
import software.amazon.awssdk.services.elasticsearch.model.StorageTypeListCopier;
import software.amazon.awssdk.services.elasticsearch.transform.LimitsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Limits
implements StructuredPojo,
ToCopyableBuilder<Builder, Limits> {
    private final List<StorageType> storageTypes;
    private final InstanceLimits instanceLimits;
    private final List<AdditionalLimit> additionalLimits;

    private Limits(BuilderImpl builder) {
        this.storageTypes = builder.storageTypes;
        this.instanceLimits = builder.instanceLimits;
        this.additionalLimits = builder.additionalLimits;
    }

    public List<StorageType> storageTypes() {
        return this.storageTypes;
    }

    public InstanceLimits instanceLimits() {
        return this.instanceLimits;
    }

    public List<AdditionalLimit> additionalLimits() {
        return this.additionalLimits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceLimits());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalLimits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Limits)) {
            return false;
        }
        Limits other = (Limits)obj;
        return Objects.equals(this.storageTypes(), other.storageTypes()) && Objects.equals(this.instanceLimits(), other.instanceLimits()) && Objects.equals(this.additionalLimits(), other.additionalLimits());
    }

    public String toString() {
        return ToString.builder((String)"Limits").add("StorageTypes", this.storageTypes()).add("InstanceLimits", (Object)this.instanceLimits()).add("AdditionalLimits", this.additionalLimits()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageTypes": {
                return Optional.ofNullable(clazz.cast(this.storageTypes()));
            }
            case "InstanceLimits": {
                return Optional.ofNullable(clazz.cast(this.instanceLimits()));
            }
            case "AdditionalLimits": {
                return Optional.ofNullable(clazz.cast(this.additionalLimits()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LimitsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StorageType> storageTypes = DefaultSdkAutoConstructList.getInstance();
        private InstanceLimits instanceLimits;
        private List<AdditionalLimit> additionalLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Limits model) {
            this.storageTypes(model.storageTypes);
            this.instanceLimits(model.instanceLimits);
            this.additionalLimits(model.additionalLimits);
        }

        public final Collection<StorageType.Builder> getStorageTypes() {
            return this.storageTypes != null ? (Collection)this.storageTypes.stream().map(StorageType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageTypes(Collection<StorageType> storageTypes) {
            this.storageTypes = StorageTypeListCopier.copy(storageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageTypes(StorageType ... storageTypes) {
            this.storageTypes(Arrays.asList(storageTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageTypes(Consumer<StorageType.Builder> ... storageTypes) {
            this.storageTypes(Stream.of(storageTypes).map(c -> (StorageType)((StorageType.Builder)StorageType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorageTypes(Collection<StorageType.BuilderImpl> storageTypes) {
            this.storageTypes = StorageTypeListCopier.copyFromBuilder(storageTypes);
        }

        public final InstanceLimits.Builder getInstanceLimits() {
            return this.instanceLimits != null ? this.instanceLimits.toBuilder() : null;
        }

        @Override
        public final Builder instanceLimits(InstanceLimits instanceLimits) {
            this.instanceLimits = instanceLimits;
            return this;
        }

        public final void setInstanceLimits(InstanceLimits.BuilderImpl instanceLimits) {
            this.instanceLimits = instanceLimits != null ? instanceLimits.build() : null;
        }

        public final Collection<AdditionalLimit.Builder> getAdditionalLimits() {
            return this.additionalLimits != null ? (Collection)this.additionalLimits.stream().map(AdditionalLimit::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalLimits(Collection<AdditionalLimit> additionalLimits) {
            this.additionalLimits = AdditionalLimitListCopier.copy(additionalLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLimits(AdditionalLimit ... additionalLimits) {
            this.additionalLimits(Arrays.asList(additionalLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalLimits(Consumer<AdditionalLimit.Builder> ... additionalLimits) {
            this.additionalLimits(Stream.of(additionalLimits).map(c -> (AdditionalLimit)((AdditionalLimit.Builder)AdditionalLimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalLimits(Collection<AdditionalLimit.BuilderImpl> additionalLimits) {
            this.additionalLimits = AdditionalLimitListCopier.copyFromBuilder(additionalLimits);
        }

        public Limits build() {
            return new Limits(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Limits> {
        public Builder storageTypes(Collection<StorageType> var1);

        public Builder storageTypes(StorageType ... var1);

        public Builder storageTypes(Consumer<StorageType.Builder> ... var1);

        public Builder instanceLimits(InstanceLimits var1);

        default public Builder instanceLimits(Consumer<InstanceLimits.Builder> instanceLimits) {
            return this.instanceLimits((InstanceLimits)((InstanceLimits.Builder)InstanceLimits.builder().applyMutation(instanceLimits)).build());
        }

        public Builder additionalLimits(Collection<AdditionalLimit> var1);

        public Builder additionalLimits(AdditionalLimit ... var1);

        public Builder additionalLimits(Consumer<AdditionalLimit.Builder> ... var1);
    }
}

