/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.transform.EncryptionAtRestOptionsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionAtRestOptions
implements StructuredPojo,
ToCopyableBuilder<Builder, EncryptionAtRestOptions> {
    private final Boolean enabled;
    private final String kmsKeyId;

    private EncryptionAtRestOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionAtRestOptions)) {
            return false;
        }
        EncryptionAtRestOptions other = (EncryptionAtRestOptions)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public String toString() {
        return ToString.builder((String)"EncryptionAtRestOptions").add("Enabled", (Object)this.enabled()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionAtRestOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionAtRestOptions model) {
            this.enabled(model.enabled);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public EncryptionAtRestOptions build() {
            return new EncryptionAtRestOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EncryptionAtRestOptions> {
        public Builder enabled(Boolean var1);

        public Builder kmsKeyId(String var1);
    }
}

