/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.elasticsearch.model.ESPartitionInstanceType;
import software.amazon.awssdk.services.elasticsearch.transform.ElasticsearchClusterConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchClusterConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, ElasticsearchClusterConfig> {
    private final String instanceType;
    private final Integer instanceCount;
    private final Boolean dedicatedMasterEnabled;
    private final Boolean zoneAwarenessEnabled;
    private final String dedicatedMasterType;
    private final Integer dedicatedMasterCount;

    private ElasticsearchClusterConfig(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.dedicatedMasterEnabled = builder.dedicatedMasterEnabled;
        this.zoneAwarenessEnabled = builder.zoneAwarenessEnabled;
        this.dedicatedMasterType = builder.dedicatedMasterType;
        this.dedicatedMasterCount = builder.dedicatedMasterCount;
    }

    public ESPartitionInstanceType instanceType() {
        return ESPartitionInstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public Boolean dedicatedMasterEnabled() {
        return this.dedicatedMasterEnabled;
    }

    public Boolean zoneAwarenessEnabled() {
        return this.zoneAwarenessEnabled;
    }

    public ESPartitionInstanceType dedicatedMasterType() {
        return ESPartitionInstanceType.fromValue(this.dedicatedMasterType);
    }

    public String dedicatedMasterTypeAsString() {
        return this.dedicatedMasterType;
    }

    public Integer dedicatedMasterCount() {
        return this.dedicatedMasterCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedMasterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneAwarenessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedMasterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedMasterCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchClusterConfig)) {
            return false;
        }
        ElasticsearchClusterConfig other = (ElasticsearchClusterConfig)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.dedicatedMasterEnabled(), other.dedicatedMasterEnabled()) && Objects.equals(this.zoneAwarenessEnabled(), other.zoneAwarenessEnabled()) && Objects.equals(this.dedicatedMasterTypeAsString(), other.dedicatedMasterTypeAsString()) && Objects.equals(this.dedicatedMasterCount(), other.dedicatedMasterCount());
    }

    public String toString() {
        return ToString.builder((String)"ElasticsearchClusterConfig").add("InstanceType", (Object)this.instanceTypeAsString()).add("InstanceCount", (Object)this.instanceCount()).add("DedicatedMasterEnabled", (Object)this.dedicatedMasterEnabled()).add("ZoneAwarenessEnabled", (Object)this.zoneAwarenessEnabled()).add("DedicatedMasterType", (Object)this.dedicatedMasterTypeAsString()).add("DedicatedMasterCount", (Object)this.dedicatedMasterCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "DedicatedMasterEnabled": {
                return Optional.ofNullable(clazz.cast(this.dedicatedMasterEnabled()));
            }
            case "ZoneAwarenessEnabled": {
                return Optional.ofNullable(clazz.cast(this.zoneAwarenessEnabled()));
            }
            case "DedicatedMasterType": {
                return Optional.ofNullable(clazz.cast(this.dedicatedMasterTypeAsString()));
            }
            case "DedicatedMasterCount": {
                return Optional.ofNullable(clazz.cast(this.dedicatedMasterCount()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchClusterConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer instanceCount;
        private Boolean dedicatedMasterEnabled;
        private Boolean zoneAwarenessEnabled;
        private String dedicatedMasterType;
        private Integer dedicatedMasterCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchClusterConfig model) {
            this.instanceType(model.instanceType);
            this.instanceCount(model.instanceCount);
            this.dedicatedMasterEnabled(model.dedicatedMasterEnabled);
            this.zoneAwarenessEnabled(model.zoneAwarenessEnabled);
            this.dedicatedMasterType(model.dedicatedMasterType);
            this.dedicatedMasterCount(model.dedicatedMasterCount);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ESPartitionInstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Boolean getDedicatedMasterEnabled() {
            return this.dedicatedMasterEnabled;
        }

        @Override
        public final Builder dedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
            return this;
        }

        public final void setDedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
        }

        public final Boolean getZoneAwarenessEnabled() {
            return this.zoneAwarenessEnabled;
        }

        @Override
        public final Builder zoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
            return this;
        }

        public final void setZoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
        }

        public final String getDedicatedMasterType() {
            return this.dedicatedMasterType;
        }

        @Override
        public final Builder dedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
            return this;
        }

        @Override
        public final Builder dedicatedMasterType(ESPartitionInstanceType dedicatedMasterType) {
            this.dedicatedMasterType(dedicatedMasterType.toString());
            return this;
        }

        public final void setDedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
        }

        public final Integer getDedicatedMasterCount() {
            return this.dedicatedMasterCount;
        }

        @Override
        public final Builder dedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
            return this;
        }

        public final void setDedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
        }

        public ElasticsearchClusterConfig build() {
            return new ElasticsearchClusterConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ElasticsearchClusterConfig> {
        public Builder instanceType(String var1);

        public Builder instanceType(ESPartitionInstanceType var1);

        public Builder instanceCount(Integer var1);

        public Builder dedicatedMasterEnabled(Boolean var1);

        public Builder zoneAwarenessEnabled(Boolean var1);

        public Builder dedicatedMasterType(String var1);

        public Builder dedicatedMasterType(ESPartitionInstanceType var1);

        public Builder dedicatedMasterCount(Integer var1);
    }
}

