/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedElasticsearchInstancesResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribeReservedElasticsearchInstancesResponse> {
    private final String nextToken;
    private final List<ReservedElasticsearchInstance> reservedElasticsearchInstances;

    private DescribeReservedElasticsearchInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedElasticsearchInstances = builder.reservedElasticsearchInstances;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ReservedElasticsearchInstance> reservedElasticsearchInstances() {
        return this.reservedElasticsearchInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedElasticsearchInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedElasticsearchInstancesResponse)) {
            return false;
        }
        DescribeReservedElasticsearchInstancesResponse other = (DescribeReservedElasticsearchInstancesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.reservedElasticsearchInstances(), other.reservedElasticsearchInstances());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedElasticsearchInstancesResponse").add("NextToken", (Object)this.nextToken()).add("ReservedElasticsearchInstances", this.reservedElasticsearchInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ReservedElasticsearchInstances": {
                return Optional.ofNullable(clazz.cast(this.reservedElasticsearchInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservedElasticsearchInstance> reservedElasticsearchInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedElasticsearchInstancesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reservedElasticsearchInstances(model.reservedElasticsearchInstances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ReservedElasticsearchInstance.Builder> getReservedElasticsearchInstances() {
            return this.reservedElasticsearchInstances != null ? (Collection)this.reservedElasticsearchInstances.stream().map(ReservedElasticsearchInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedElasticsearchInstances(Collection<ReservedElasticsearchInstance> reservedElasticsearchInstances) {
            this.reservedElasticsearchInstances = ReservedElasticsearchInstanceListCopier.copy(reservedElasticsearchInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedElasticsearchInstances(ReservedElasticsearchInstance ... reservedElasticsearchInstances) {
            this.reservedElasticsearchInstances(Arrays.asList(reservedElasticsearchInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedElasticsearchInstances(Consumer<ReservedElasticsearchInstance.Builder> ... reservedElasticsearchInstances) {
            this.reservedElasticsearchInstances(Stream.of(reservedElasticsearchInstances).map(c -> (ReservedElasticsearchInstance)((ReservedElasticsearchInstance.Builder)ReservedElasticsearchInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedElasticsearchInstances(Collection<ReservedElasticsearchInstance.BuilderImpl> reservedElasticsearchInstances) {
            this.reservedElasticsearchInstances = ReservedElasticsearchInstanceListCopier.copyFromBuilder(reservedElasticsearchInstances);
        }

        @Override
        public DescribeReservedElasticsearchInstancesResponse build() {
            return new DescribeReservedElasticsearchInstancesResponse(this);
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    CopyableBuilder<Builder, DescribeReservedElasticsearchInstancesResponse> {
        public Builder nextToken(String var1);

        public Builder reservedElasticsearchInstances(Collection<ReservedElasticsearchInstance> var1);

        public Builder reservedElasticsearchInstances(ReservedElasticsearchInstance ... var1);

        public Builder reservedElasticsearchInstances(Consumer<ReservedElasticsearchInstance.Builder> ... var1);
    }
}

