/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOffering;
import software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstanceOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedElasticsearchInstanceOfferingsResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribeReservedElasticsearchInstanceOfferingsResponse> {
    private final String nextToken;
    private final List<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings;

    private DescribeReservedElasticsearchInstanceOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedElasticsearchInstanceOfferings = builder.reservedElasticsearchInstanceOfferings;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings() {
        return this.reservedElasticsearchInstanceOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedElasticsearchInstanceOfferings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedElasticsearchInstanceOfferingsResponse)) {
            return false;
        }
        DescribeReservedElasticsearchInstanceOfferingsResponse other = (DescribeReservedElasticsearchInstanceOfferingsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.reservedElasticsearchInstanceOfferings(), other.reservedElasticsearchInstanceOfferings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReservedElasticsearchInstanceOfferingsResponse").add("NextToken", (Object)this.nextToken()).add("ReservedElasticsearchInstanceOfferings", this.reservedElasticsearchInstanceOfferings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ReservedElasticsearchInstanceOfferings": {
                return Optional.ofNullable(clazz.cast(this.reservedElasticsearchInstanceOfferings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedElasticsearchInstanceOfferingsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reservedElasticsearchInstanceOfferings(model.reservedElasticsearchInstanceOfferings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ReservedElasticsearchInstanceOffering.Builder> getReservedElasticsearchInstanceOfferings() {
            return this.reservedElasticsearchInstanceOfferings != null ? (Collection)this.reservedElasticsearchInstanceOfferings.stream().map(ReservedElasticsearchInstanceOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedElasticsearchInstanceOfferings(Collection<ReservedElasticsearchInstanceOffering> reservedElasticsearchInstanceOfferings) {
            this.reservedElasticsearchInstanceOfferings = ReservedElasticsearchInstanceOfferingListCopier.copy(reservedElasticsearchInstanceOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedElasticsearchInstanceOfferings(ReservedElasticsearchInstanceOffering ... reservedElasticsearchInstanceOfferings) {
            this.reservedElasticsearchInstanceOfferings(Arrays.asList(reservedElasticsearchInstanceOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedElasticsearchInstanceOfferings(Consumer<ReservedElasticsearchInstanceOffering.Builder> ... reservedElasticsearchInstanceOfferings) {
            this.reservedElasticsearchInstanceOfferings(Stream.of(reservedElasticsearchInstanceOfferings).map(c -> (ReservedElasticsearchInstanceOffering)((ReservedElasticsearchInstanceOffering.Builder)ReservedElasticsearchInstanceOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedElasticsearchInstanceOfferings(Collection<ReservedElasticsearchInstanceOffering.BuilderImpl> reservedElasticsearchInstanceOfferings) {
            this.reservedElasticsearchInstanceOfferings = ReservedElasticsearchInstanceOfferingListCopier.copyFromBuilder(reservedElasticsearchInstanceOfferings);
        }

        @Override
        public DescribeReservedElasticsearchInstanceOfferingsResponse build() {
            return new DescribeReservedElasticsearchInstanceOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    CopyableBuilder<Builder, DescribeReservedElasticsearchInstanceOfferingsResponse> {
        public Builder nextToken(String var1);

        public Builder reservedElasticsearchInstanceOfferings(Collection<ReservedElasticsearchInstanceOffering> var1);

        public Builder reservedElasticsearchInstanceOfferings(ReservedElasticsearchInstanceOffering ... var1);

        public Builder reservedElasticsearchInstanceOfferings(Consumer<ReservedElasticsearchInstanceOffering.Builder> ... var1);
    }
}

