/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.Limits;
import software.amazon.awssdk.services.elasticsearch.model.LimitsByRoleCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeElasticsearchInstanceTypeLimitsResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsResponse> {
    private final Map<String, Limits> limitsByRole;

    private DescribeElasticsearchInstanceTypeLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.limitsByRole = builder.limitsByRole;
    }

    public Map<String, Limits> limitsByRole() {
        return this.limitsByRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limitsByRole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchInstanceTypeLimitsResponse)) {
            return false;
        }
        DescribeElasticsearchInstanceTypeLimitsResponse other = (DescribeElasticsearchInstanceTypeLimitsResponse)((Object)obj);
        return Objects.equals(this.limitsByRole(), other.limitsByRole());
    }

    public String toString() {
        return ToString.builder((String)"DescribeElasticsearchInstanceTypeLimitsResponse").add("LimitsByRole", this.limitsByRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LimitsByRole": {
                return Optional.ofNullable(clazz.cast(this.limitsByRole()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private Map<String, Limits> limitsByRole = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchInstanceTypeLimitsResponse model) {
            super(model);
            this.limitsByRole(model.limitsByRole);
        }

        public final Map<String, Limits.Builder> getLimitsByRole() {
            return this.limitsByRole != null ? CollectionUtils.mapValues(this.limitsByRole, Limits::toBuilder) : null;
        }

        @Override
        public final Builder limitsByRole(Map<String, Limits> limitsByRole) {
            this.limitsByRole = LimitsByRoleCopier.copy(limitsByRole);
            return this;
        }

        public final void setLimitsByRole(Map<String, Limits.BuilderImpl> limitsByRole) {
            this.limitsByRole = LimitsByRoleCopier.copyFromBuilder(limitsByRole);
        }

        @Override
        public DescribeElasticsearchInstanceTypeLimitsResponse build() {
            return new DescribeElasticsearchInstanceTypeLimitsResponse(this);
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    CopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsResponse> {
        public Builder limitsByRole(Map<String, Limits> var1);
    }
}

